/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.registry;

import java.util.AbstractMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.wildfly.clustering.server.AutoCloseableProvider;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupProvider;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroupProvider;
import org.wildfly.clustering.server.infinispan.registry.CacheRegistry;
import org.wildfly.clustering.server.infinispan.registry.CacheRegistryConfiguration;
import org.wildfly.clustering.server.registry.Registry;
import org.wildfly.clustering.server.registry.RegistryFactory;

public class CacheContainerRegistryProvider<K, V>
extends AutoCloseableProvider
implements Function<Map.Entry<K, V>, Registry<CacheContainerGroupMember, K, V>> {
    private static final String CACHE_NAME = "registry";
    private final RegistryFactory<CacheContainerGroupMember, K, V> factory;

    public CacheContainerRegistryProvider(String clusterName, String memberName) throws Exception {
        final EmbeddedCacheManagerGroupProvider provider = new EmbeddedCacheManagerGroupProvider(clusterName, memberName);
        this.accept(() -> ((CacheContainerGroupProvider)provider).close());
        EmbeddedCacheManager manager = provider.getCacheManager();
        manager.defineConfiguration(CACHE_NAME, new ConfigurationBuilder().clustering().cacheMode(CacheMode.REPL_SYNC).build());
        this.accept(() -> manager.undefineConfiguration(CACHE_NAME));
        final Cache cache = manager.getCache(CACHE_NAME);
        cache.start();
        this.accept(() -> ((Cache)cache).stop());
        final CacheRegistryConfiguration config = new CacheRegistryConfiguration(){
            final /* synthetic */ CacheContainerRegistryProvider this$0;
            {
                this.this$0 = this$0;
            }

            public <KK, VV> Cache<KK, VV> getCache() {
                return cache;
            }

            public CacheContainerGroup getGroup() {
                return provider.getGroup();
            }
        };
        this.factory = RegistryFactory.singleton((BiFunction)new BiFunction<Map.Entry<K, V>, Runnable, Registry<CacheContainerGroupMember, K, V>>(this){
            final /* synthetic */ CacheContainerRegistryProvider this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Registry<CacheContainerGroupMember, K, V> apply(Map.Entry<K, V> entry, Runnable closeTask) {
                return new CacheRegistry(config, entry, closeTask);
            }
        });
    }

    @Override
    public Registry<CacheContainerGroupMember, K, V> apply(Map.Entry<K, V> entry) {
        return this.factory.createRegistry(new AbstractMap.SimpleImmutableEntry<K, V>(entry.getKey(), entry.getValue()));
    }
}

