/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.scheduler;

import java.time.Duration;
import java.time.Instant;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.TesterFactory;
import org.wildfly.clustering.marshalling.junit.TesterFactorySource;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.server.expiration.ExpirationMetaData;
import org.wildfly.clustering.server.infinispan.expiration.ScheduleWithExpirationMetaDataCommand;
import org.wildfly.clustering.server.infinispan.scheduler.CancelCommand;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleCommand;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleWithPersistentMetaDataCommand;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleWithTransientMetaDataCommand;

public class CommandMarshallerTestCase {
    @ParameterizedTest
    @TesterFactorySource(value={ProtoStreamTesterFactory.class})
    public void testScheduleWithLocalMetaDataCommand(TesterFactory factory) {
        Tester tester = factory.createTester(this::assertEquals);
        tester.accept(new ScheduleWithTransientMetaDataCommand((Object)"foo", null));
        tester.accept(new ScheduleWithTransientMetaDataCommand((Object)"foo", (Object)"bar"));
    }

    @ParameterizedTest
    @TesterFactorySource(value={ProtoStreamTesterFactory.class})
    public void testCancelCommand(TesterFactory factory) {
        Tester tester = factory.createTester(this::assertEquals);
        tester.accept(new CancelCommand((Object)"foo"));
    }

    <I, M> void assertEquals(CancelCommand<I, M> expected, CancelCommand<I, M> actual) {
        Assertions.assertEquals((Object)expected.getId(), (Object)actual.getId());
    }

    @ParameterizedTest
    @TesterFactorySource(value={ProtoStreamTesterFactory.class})
    public void testScheduleWithMetaDataCommand(TesterFactory factory) {
        Tester tester = factory.createTester(this::assertEquals);
        tester.accept(new ScheduleWithPersistentMetaDataCommand((Object)"foo", (Object)"bar"));
    }

    @ParameterizedTest
    @TesterFactorySource(value={ProtoStreamTesterFactory.class})
    public void testScheduleWithExpirationMetaDataCommand(TesterFactory factory) {
        Tester tester = factory.createTester(this::assertExpirationEquals);
        tester.accept(new ScheduleWithExpirationMetaDataCommand((Object)"foo", (ExpirationMetaData)new TestExpirationMetaData(Duration.ZERO, Instant.EPOCH)));
        tester.accept(new ScheduleWithExpirationMetaDataCommand((Object)"bar", (ExpirationMetaData)new TestExpirationMetaData(Duration.ofMinutes(30L), Instant.now())));
        tester.accept(new ScheduleWithExpirationMetaDataCommand((Object)"bar", (ExpirationMetaData)new TestExpirationMetaData(Duration.ofHours(1L), Instant.now())));
    }

    <I, M> void assertEquals(ScheduleCommand<I, M> expected, ScheduleCommand<I, M> actual) {
        Assertions.assertEquals((Object)expected.getId(), (Object)actual.getId());
        Assertions.assertEquals((Object)expected.getPersistentMetaData(), (Object)actual.getPersistentMetaData());
    }

    <I> void assertExpirationEquals(ScheduleCommand<I, ExpirationMetaData> expected, ScheduleCommand<I, ExpirationMetaData> actual) {
        Assertions.assertEquals((Object)expected.getId(), (Object)actual.getId());
        Assertions.assertEquals((Object)((ExpirationMetaData)expected.getPersistentMetaData()).getTimeout(), (Object)((ExpirationMetaData)actual.getPersistentMetaData()).getTimeout());
        Assertions.assertEquals((Object)((ExpirationMetaData)expected.getPersistentMetaData()).getLastAccessTime(), (Object)((ExpirationMetaData)actual.getPersistentMetaData()).getLastAccessTime());
    }

    private static class TestExpirationMetaData
    implements ExpirationMetaData {
        private final Duration timeout;
        private final Instant lastAccessTime;

        TestExpirationMetaData(Duration timeout, Instant lastAccessTime) {
            this.timeout = timeout;
            this.lastAccessTime = lastAccessTime;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public Instant getLastAccessTime() {
            return this.lastAccessTime;
        }
    }
}

