/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.provider;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.logging.Logger;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.Locality;
import org.wildfly.clustering.context.DefaultExecutorService;
import org.wildfly.clustering.context.ExecutorServiceFactory;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMemberFactory;
import org.wildfly.clustering.server.infinispan.provider.AddressSetAddFunction;
import org.wildfly.clustering.server.infinispan.provider.AddressSetRemoveFunction;
import org.wildfly.clustering.server.infinispan.provider.CacheContainerServiceProviderRegistrar;
import org.wildfly.clustering.server.infinispan.provider.CacheServiceProviderRegistrarConfiguration;
import org.wildfly.clustering.server.local.provider.DefaultServiceProviderRegistration;
import org.wildfly.clustering.server.provider.ServiceProviderListener;
import org.wildfly.clustering.server.provider.ServiceProviderRegistrar;
import org.wildfly.clustering.server.provider.ServiceProviderRegistration;

@Listener(observation=Listener.Observation.POST)
public class CacheServiceProviderRegistrar<T>
implements CacheContainerServiceProviderRegistrar<T>,
AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(CacheServiceProviderRegistrar.class);
    private final Supplier<Batch> batchFactory;
    private final ConcurrentMap<T, Map.Entry<ServiceProviderListener<CacheContainerGroupMember>, ExecutorService>> listeners = new ConcurrentHashMap<T, Map.Entry<ServiceProviderListener<CacheContainerGroupMember>, ExecutorService>>();
    private final Cache<T, Set<Address>> cache;
    private final CacheContainerGroup group;
    private final Executor executor;

    public CacheServiceProviderRegistrar(CacheServiceProviderRegistrarConfiguration config) {
        this.group = config.getGroup();
        this.cache = config.getWriteOnlyCache();
        this.batchFactory = config.getBatchFactory();
        this.executor = config.getExecutor();
        this.cache.addListener((Object)this);
    }

    @Override
    public void close() {
        this.cache.removeListener((Object)this);
        for (Object service : this.listeners.keySet()) {
            this.unregisterLocal(service);
        }
    }

    private void shutdown(ExecutorService executor) {
        executor.shutdown();
        try {
            executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public CacheContainerGroup getGroup() {
        return this.group;
    }

    public ServiceProviderRegistration<T, CacheContainerGroupMember> register(T service) {
        return this.register(service, (ServiceProviderListener<CacheContainerGroupMember>)((ServiceProviderListener)null));
    }

    public ServiceProviderRegistration<T, CacheContainerGroupMember> register(T service, ServiceProviderListener<CacheContainerGroupMember> listener) {
        AbstractMap.SimpleEntry<ServiceProviderListener<CacheContainerGroupMember>, Object> newEntry = new AbstractMap.SimpleEntry<ServiceProviderListener<CacheContainerGroupMember>, Object>(listener, null);
        Map.Entry entry = this.listeners.computeIfAbsent(service, key -> {
            if (listener != null) {
                newEntry.setValue(new DefaultExecutorService((Function)ExecutorServiceFactory.SINGLE_THREAD, Thread.currentThread().getContextClassLoader()));
            }
            return newEntry;
        });
        if (entry != newEntry) {
            throw new IllegalArgumentException(service.toString());
        }
        this.registerLocal(service);
        return new DefaultServiceProviderRegistration((ServiceProviderRegistrar)this, service, () -> this.unregisterLocal(service));
    }

    void registerLocal(T service) {
        Address localAddress = this.cache.getCacheManager().getAddress();
        try (Batch batch = this.batchFactory.get();){
            this.register(service, localAddress);
        }
    }

    void register(T service, Address address) {
        this.cache.compute(service, (BiFunction)((Object)new AddressSetAddFunction(address)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterLocal(T service) {
        try {
            Address localAddress = this.cache.getCacheManager().getAddress();
            try (Batch batch = this.batchFactory.get();){
                this.unregister(service, Set.of(localAddress));
            }
        }
        finally {
            ExecutorService executor;
            Map.Entry oldEntry = (Map.Entry)this.listeners.remove(service);
            if (oldEntry != null && (executor = (ExecutorService)oldEntry.getValue()) != null) {
                this.shutdown(executor);
            }
        }
    }

    void unregister(T service, Set<Address> addresses) {
        this.cache.compute(service, (BiFunction)((Object)new AddressSetRemoveFunction(addresses)));
    }

    public Set<CacheContainerGroupMember> getProviders(T service) {
        Set addresses = (Set)this.cache.get(service);
        return addresses != null ? this.map(addresses) : Set.of();
    }

    public Set<T> getServices() {
        return this.cache.keySet();
    }

    private Set<CacheContainerGroupMember> map(Set<Address> addresses) {
        return addresses.stream().map(arg_0 -> ((CacheContainerGroupMemberFactory)this.group.getGroupMemberFactory()).createGroupMember(arg_0)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    @TopologyChanged
    public CompletionStage<Void> topologyChanged(TopologyChangedEvent<T, Set<Address>> event) {
        if (this.group.isSingleton()) {
            return CompletableFuture.completedStage(null);
        }
        ConsistentHash previousHash = event.getWriteConsistentHashAtStart();
        List previousMembers = previousHash.getMembers();
        ConsistentHash hash = event.getWriteConsistentHashAtEnd();
        List members = hash.getMembers();
        if (!members.equals(previousMembers)) {
            Set localServices;
            Cache cache = event.getCache();
            Address localAddress = cache.getCacheManager().getAddress();
            HashSet leftMembers = new HashSet(previousMembers);
            leftMembers.removeAll(members);
            if (!leftMembers.isEmpty()) {
                Locality locality = Locality.forConsistentHash((Cache)cache, (ConsistentHash)hash);
                Iterator addresses = leftMembers.iterator();
                while (addresses.hasNext()) {
                    if (locality.isLocal(addresses.next())) continue;
                    addresses.remove();
                }
            }
            Set<Object> set = localServices = !previousMembers.contains(localAddress) ? this.listeners.keySet() : Collections.emptySet();
            if (!leftMembers.isEmpty() || !localServices.isEmpty()) {
                try {
                    this.executor.execute(() -> {
                        if (!leftMembers.isEmpty()) {
                            try (Batch batch = this.batchFactory.get();
                                 CloseableIterator keys = cache.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK).keySet().iterator();){
                                while (keys.hasNext()) {
                                    this.unregister(keys.next(), leftMembers);
                                }
                            }
                        }
                        if (!localServices.isEmpty()) {
                            for (Object localService : localServices) {
                                this.registerLocal(localService);
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }
        return CompletableFuture.completedStage(null);
    }

    @CacheEntryCreated
    public CompletionStage<Void> created(CacheEntryCreatedEvent<T, Set<Address>> event) {
        return this.updated(event.getKey(), (Set)event.getValue());
    }

    @CacheEntryModified
    public CompletionStage<Void> modified(CacheEntryModifiedEvent<T, Set<Address>> event) {
        return !Objects.equals(event.getOldValue(), event.getNewValue()) ? this.updated(event.getKey(), (Set)event.getNewValue()) : CompletableFuture.completedFuture(null);
    }

    private CompletionStage<Void> updated(T service, Set<Address> providers) {
        ServiceProviderListener listener;
        Map.Entry entry = (Map.Entry)this.listeners.get(service);
        if (entry != null && (listener = (ServiceProviderListener)entry.getKey()) != null) {
            Executor executor = (Executor)entry.getValue();
            Set<CacheContainerGroupMember> members = this.map(providers);
            try {
                executor.execute(() -> {
                    try {
                        listener.providersChanged(members);
                    }
                    catch (Throwable e) {
                        LOGGER.warn((Object)e.getLocalizedMessage(), e);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        return CompletableFuture.completedStage(null);
    }
}

