/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupProvider;
import org.wildfly.clustering.server.infinispan.ChannelEmbeddedCacheManagerGroupConfiguration;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerFactory;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroup;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroupConfiguration;
import org.wildfly.clustering.server.jgroups.ChannelGroup;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.server.jgroups.ForkChannelFactory;
import org.wildfly.clustering.server.jgroups.JChannelFactory;
import org.wildfly.clustering.server.jgroups.JChannelGroup;

public class EmbeddedCacheManagerGroupProvider
implements CacheContainerGroupProvider {
    private static final String CONTAINER_NAME = "container";
    private final JChannel channel;
    private final ChannelGroup channelGroup;
    private final EmbeddedCacheManager manager;
    private final CacheContainerGroup group;

    public EmbeddedCacheManagerGroupProvider(String clusterName, String memberName) throws Exception {
        this.channel = JChannelFactory.INSTANCE.apply(memberName);
        this.channel.connect(clusterName);
        this.channelGroup = new JChannelGroup(this.channel);
        this.manager = new EmbeddedCacheManagerFactory((Function<String, JChannel>)new ForkChannelFactory(this.channel), clusterName, memberName).apply(CONTAINER_NAME, EmbeddedCacheManagerGroup.class.getClassLoader());
        this.group = new EmbeddedCacheManagerGroup((EmbeddedCacheManagerGroupConfiguration)new ChannelEmbeddedCacheManagerGroupConfiguration(){

            public Group<Address, ChannelGroupMember> getGroup() {
                return EmbeddedCacheManagerGroupProvider.this.channelGroup;
            }

            public EmbeddedCacheManager getCacheContainer() {
                return EmbeddedCacheManagerGroupProvider.this.manager;
            }
        });
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        return this.manager;
    }

    public JChannel getChannel() {
        return this.channel;
    }

    @Override
    public CacheContainerGroup getGroup() {
        return this.group;
    }

    public void close() {
        try {
            this.manager.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.channelGroup.close();
        this.channel.disconnect();
        this.channel.close();
    }
}

