/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan;

import java.io.IOException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.infinispan.commons.marshall.IdentityMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroup;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroupConfiguration;
import org.wildfly.clustering.server.infinispan.LocalEmbeddedCacheManagerGroupConfiguration;

public class LocalGroupTestCase {
    private static final String GROUP_NAME = "group";
    private static final String MEMBER_NAME = "member";

    @Test
    public void test() throws IOException {
        GlobalConfiguration global = new GlobalConfigurationBuilder().nonClusteredDefault().cacheManagerName(GROUP_NAME).serialization().marshaller((Marshaller)IdentityMarshaller.INSTANCE).addContextInitializer(new SerializationContextInitializer(){

            @Deprecated
            public String getProtoFile() {
                return null;
            }

            @Deprecated
            public String getProtoFileName() {
                return null;
            }

            public void registerMarshallers(SerializationContext context) {
            }

            public void registerSchema(SerializationContext context) {
            }
        }).transport().nodeName(MEMBER_NAME).build();
        try (DefaultCacheManager manager = new DefaultCacheManager(global, true);){
            LocalEmbeddedCacheManagerGroupConfiguration config = () -> LocalGroupTestCase.lambda$test$0((EmbeddedCacheManager)manager);
            EmbeddedCacheManagerGroup group = new EmbeddedCacheManagerGroup((EmbeddedCacheManagerGroupConfiguration)config);
            Assertions.assertThat((String)group.getName()).isSameAs((Object)GROUP_NAME);
            Assertions.assertThat((String)((CacheContainerGroupMember)group.getLocalMember()).getName()).isSameAs((Object)MEMBER_NAME);
            Assertions.assertThat((List)group.getMembership().getMembers()).containsExactly((Object[])new CacheContainerGroupMember[]{(CacheContainerGroupMember)group.getLocalMember()});
            Assertions.assertThat((Comparable)((CacheContainerGroupMember)group.getMembership().getCoordinator())).isSameAs((Object)group.getLocalMember());
        }
    }

    private static /* synthetic */ EmbeddedCacheManager lambda$test$0(EmbeddedCacheManager manager) {
        return manager;
    }
}

