/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.scheduler;

import java.time.Duration;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.TesterFactory;
import org.wildfly.clustering.marshalling.junit.TesterFactorySource;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.server.expiration.ExpirationMetaData;
import org.wildfly.clustering.server.infinispan.expiration.ScheduleWithExpirationMetaDataCommand;
import org.wildfly.clustering.server.infinispan.scheduler.CancelCommand;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleWithPersistentMetaDataCommand;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleWithTransientMetaDataCommand;

public class CommandMarshallerTestCase {
    @ParameterizedTest
    @TesterFactorySource(value={ProtoStreamTesterFactory.class})
    public void testScheduleWithLocalMetaDataCommand(TesterFactory factory) {
        Tester tester = factory.createTester((expected, actual) -> {
            Assertions.assertThat((String)((String)actual.getId())).isEqualTo((String)expected.getId());
            Assertions.assertThat((String)((String)actual.getMetaData())).isEqualTo((String)expected.getMetaData());
        });
        tester.accept(new ScheduleWithTransientMetaDataCommand((Object)"foo", null));
        tester.accept(new ScheduleWithTransientMetaDataCommand((Object)"foo", (Object)"bar"));
    }

    @ParameterizedTest
    @TesterFactorySource(value={ProtoStreamTesterFactory.class})
    public void testCancelCommand(TesterFactory factory) {
        Tester tester = factory.createTester((expected, actual) -> Assertions.assertThat((String)((String)actual.getId())).isEqualTo((String)expected.getId()));
        tester.accept(new CancelCommand((Object)"foo"));
    }

    @ParameterizedTest
    @TesterFactorySource(value={ProtoStreamTesterFactory.class})
    public void testScheduleWithMetaDataCommand(TesterFactory factory) {
        Tester tester = factory.createTester((expected, actual) -> {
            Assertions.assertThat((String)((String)actual.getId())).isEqualTo((String)expected.getId());
            Assertions.assertThat((String)((String)actual.getMetaData())).isEqualTo((String)expected.getMetaData());
        });
        tester.accept(new ScheduleWithPersistentMetaDataCommand((Object)"foo", (Object)"bar"));
    }

    @ParameterizedTest
    @TesterFactorySource(value={ProtoStreamTesterFactory.class})
    public void testScheduleWithExpirationMetaDataCommand(TesterFactory factory) {
        Tester tester = factory.createTester((expected, actual) -> {
            Assertions.assertThat((String)((String)actual.getId())).isEqualTo((String)expected.getId());
            Assertions.assertThat((Duration)((ExpirationMetaData)actual.getMetaData()).getTimeout()).isEqualTo((Object)((ExpirationMetaData)expected.getMetaData()).getTimeout());
            Assertions.assertThat((Instant)((ExpirationMetaData)actual.getMetaData()).getLastAccessTime()).isEqualTo((Object)((ExpirationMetaData)expected.getMetaData()).getLastAccessTime());
        });
        tester.accept(new ScheduleWithExpirationMetaDataCommand((Object)"foo", (ExpirationMetaData)new TestExpirationMetaData(Duration.ZERO, Instant.EPOCH)));
        tester.accept(new ScheduleWithExpirationMetaDataCommand((Object)"bar", (ExpirationMetaData)new TestExpirationMetaData(Duration.ofMinutes(30L), Instant.now())));
        tester.accept(new ScheduleWithExpirationMetaDataCommand((Object)"bar", (ExpirationMetaData)new TestExpirationMetaData(Duration.ofHours(1L), Instant.now())));
    }

    private static class TestExpirationMetaData
    implements ExpirationMetaData {
        private final Duration timeout;
        private final Instant lastAccessTime;

        TestExpirationMetaData(Duration timeout, Instant lastAccessTime) {
            this.timeout = timeout;
            this.lastAccessTime = lastAccessTime;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public Instant getLastAccessTime() {
            return this.lastAccessTime;
        }
    }
}

