/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.provider;

import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.wildfly.clustering.server.AutoCloseableProvider;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupProvider;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroupProvider;
import org.wildfly.clustering.server.infinispan.provider.CacheContainerServiceProviderRegistrar;
import org.wildfly.clustering.server.infinispan.provider.CacheServiceProviderRegistrar;
import org.wildfly.clustering.server.infinispan.provider.CacheServiceProviderRegistrarConfiguration;

public class CacheContainerServiceProviderRegistrarProvider<T>
extends AutoCloseableProvider
implements Supplier<CacheContainerServiceProviderRegistrar<T>> {
    private static final String CACHE_NAME = "registry";
    private final CacheServiceProviderRegistrar<T> registrar;

    public CacheContainerServiceProviderRegistrarProvider(String clusterName, String memberName) throws Exception {
        final EmbeddedCacheManagerGroupProvider provider = new EmbeddedCacheManagerGroupProvider(clusterName, memberName);
        this.accept(() -> ((CacheContainerGroupProvider)provider).close());
        EmbeddedCacheManager manager = provider.getCacheManager();
        manager.defineConfiguration(CACHE_NAME, new ConfigurationBuilder().clustering().cacheMode(CacheMode.REPL_SYNC).build());
        this.accept(() -> manager.undefineConfiguration(CACHE_NAME));
        final Cache cache = manager.getCache(CACHE_NAME);
        cache.start();
        this.accept(() -> ((Cache)cache).stop());
        this.registrar = new CacheServiceProviderRegistrar(new CacheServiceProviderRegistrarConfiguration(){
            final /* synthetic */ CacheContainerServiceProviderRegistrarProvider this$0;
            {
                this.this$0 = this$0;
            }

            public <K, V> Cache<K, V> getCache() {
                return cache;
            }

            public Object getId() {
                return CacheContainerServiceProviderRegistrarProvider.CACHE_NAME;
            }

            public CacheContainerGroup getGroup() {
                return provider.getGroup();
            }
        });
        this.accept(() -> this.registrar.close());
    }

    @Override
    public CacheContainerServiceProviderRegistrar<T> get() {
        return this.registrar;
    }
}

