/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.provider;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheType;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.wildfly.clustering.context.AbstractContext;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroupContext;
import org.wildfly.clustering.server.infinispan.provider.CacheContainerServiceProviderRegistrar;
import org.wildfly.clustering.server.infinispan.provider.CacheServiceProviderRegistrar;
import org.wildfly.clustering.server.infinispan.provider.CacheServiceProviderRegistrarConfiguration;

public class CacheContainerServiceProviderRegistrarContext<T>
extends AbstractContext<CacheContainerServiceProviderRegistrar<T>> {
    private static final String CACHE_NAME = "registry";
    private final CacheServiceProviderRegistrar<T> registrar;

    public CacheContainerServiceProviderRegistrarContext(String clusterName, String memberName) throws Exception {
        EmbeddedCacheManagerGroupContext groupContext = new EmbeddedCacheManagerGroupContext(clusterName, memberName);
        this.accept(() -> ((Context)groupContext).close());
        EmbeddedCacheManager manager = ((CacheContainerGroup)groupContext.get()).getCacheContainer();
        manager.defineConfiguration(CACHE_NAME, new ConfigurationBuilder().clustering().cacheType(CacheType.REPLICATION).build());
        this.accept(() -> manager.undefineConfiguration(CACHE_NAME));
        final Cache cache = manager.getCache(CACHE_NAME);
        cache.start();
        this.accept(() -> ((Cache)cache).stop());
        this.registrar = new CacheServiceProviderRegistrar(new CacheServiceProviderRegistrarConfiguration(){
            final /* synthetic */ Context val$groupContext;
            {
                this.val$groupContext = context;
            }

            public <K, V> Cache<K, V> getCache() {
                return cache;
            }

            public Object getId() {
                return CacheContainerServiceProviderRegistrarContext.CACHE_NAME;
            }

            public CacheContainerGroup getGroup() {
                return (CacheContainerGroup)this.val$groupContext.get();
            }
        });
        this.accept(() -> this.registrar.close());
    }

    public CacheContainerServiceProviderRegistrar<T> get() {
        return this.registrar;
    }
}

