/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.registry;

import java.util.Map;
import java.util.function.BiFunction;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheType;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.wildfly.clustering.context.AbstractContext;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroupContext;
import org.wildfly.clustering.server.infinispan.registry.CacheRegistry;
import org.wildfly.clustering.server.infinispan.registry.CacheRegistryConfiguration;
import org.wildfly.clustering.server.registry.Registry;
import org.wildfly.clustering.server.registry.RegistryFactory;

public class CacheContainerRegistryFactoryContext<K, V>
extends AbstractContext<RegistryFactory<CacheContainerGroupMember, K, V>> {
    private static final String CACHE_NAME = "registry";
    private final RegistryFactory<CacheContainerGroupMember, K, V> factory;

    public CacheContainerRegistryFactoryContext(String clusterName, String memberName) throws Exception {
        EmbeddedCacheManagerGroupContext groupContext = new EmbeddedCacheManagerGroupContext(clusterName, memberName);
        this.accept(() -> ((Context)groupContext).close());
        final CacheContainerGroup group = (CacheContainerGroup)groupContext.get();
        EmbeddedCacheManager manager = group.getCacheContainer();
        manager.defineConfiguration(CACHE_NAME, new ConfigurationBuilder().clustering().cacheType(CacheType.REPLICATION).build());
        this.accept(() -> manager.undefineConfiguration(CACHE_NAME));
        final Cache cache = manager.getCache(CACHE_NAME);
        cache.start();
        this.accept(() -> ((Cache)cache).stop());
        final CacheRegistryConfiguration config = new CacheRegistryConfiguration(){

            public <KK, VV> Cache<KK, VV> getCache() {
                return cache;
            }

            public CacheContainerGroup getGroup() {
                return group;
            }
        };
        this.factory = RegistryFactory.singleton((BiFunction)new BiFunction<Map.Entry<K, V>, Runnable, Registry<CacheContainerGroupMember, K, V>>(){

            @Override
            public Registry<CacheContainerGroupMember, K, V> apply(Map.Entry<K, V> entry, Runnable closeTask) {
                return new CacheRegistry(config, entry, closeTask);
            }
        });
    }

    public RegistryFactory<CacheContainerGroupMember, K, V> get() {
        return this.factory;
    }
}

