/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.registry;

import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.registry.CacheContainerRegistryFactoryContext;
import org.wildfly.clustering.server.registry.Registry;
import org.wildfly.clustering.server.registry.RegistryListener;

public class CacheRegistryITCase {
    private static final String CLUSTER_NAME = "cluster";
    private static final String MEMBER_1 = "member1";
    private static final String MEMBER_2 = "member2";

    @Test
    public void test() throws Exception {
        Map.Entry<String, UUID> entry1 = Map.entry("foo", UUID.randomUUID());
        Map.Entry<String, UUID> entry2 = Map.entry("bar", UUID.randomUUID());
        try (CacheContainerRegistryFactoryContext factory1 = new CacheContainerRegistryFactoryContext(CLUSTER_NAME, MEMBER_1);
             Registry registry1 = factory1.get().createRegistry(entry1);){
            CacheContainerGroupMember member1 = (CacheContainerGroupMember)registry1.getGroup().getLocalMember();
            Assertions.assertThat((Object)registry1.getEntry((GroupMember)member1)).isEqualTo(entry1);
            Assertions.assertThat((Map)registry1.getEntries()).containsExactlyEntriesOf(Map.ofEntries(entry1));
            RegistryListener listener = (RegistryListener)Mockito.mock(RegistryListener.class);
            try (Registration registration = registry1.register((Object)listener);){
                Mockito.verifyNoInteractions((Object[])new Object[]{listener});
                try (CacheContainerRegistryFactoryContext factory2 = new CacheContainerRegistryFactoryContext(CLUSTER_NAME, MEMBER_2);
                     Registry registry2 = factory2.get().createRegistry(entry2);){
                    CacheContainerGroupMember member2 = (CacheContainerGroupMember)registry2.getGroup().getLocalMember();
                    Assertions.assertThat((Object)registry1.getEntry((GroupMember)member1)).isEqualTo(entry1);
                    Assertions.assertThat((Object)registry2.getEntry((GroupMember)member1)).isEqualTo(entry1);
                    Assertions.assertThat((Object)registry1.getEntry((GroupMember)member2)).isEqualTo(entry2);
                    Assertions.assertThat((Object)registry2.getEntry((GroupMember)member2)).isEqualTo(entry2);
                    Assertions.assertThat((Map)registry1.getEntries()).containsExactlyInAnyOrderEntriesOf(Map.ofEntries(entry1, entry2));
                    Assertions.assertThat((Map)registry2.getEntries()).containsExactlyInAnyOrderEntriesOf(Map.ofEntries(entry1, entry2));
                    Thread.sleep(100L);
                    ((RegistryListener)Mockito.verify((Object)listener)).added(Map.ofEntries(entry2));
                    Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
                }
                Assertions.assertThat((Object)registry1.getEntry((GroupMember)member1)).isEqualTo(entry1);
                Assertions.assertThat((Map)registry1.getEntries()).containsExactlyEntriesOf(Map.ofEntries(entry1));
                Thread.sleep(100L);
                ((RegistryListener)Mockito.verify((Object)listener)).removed(Map.ofEntries(entry2));
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
            }
        }
    }
}

