/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.scheduler;

import java.util.Map;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.server.infinispan.scheduler.Scheduler;

public interface CacheEntryScheduler<I, K extends Key<I>, V, M>
extends Scheduler<I, M> {
    @Override
    public void schedule(Map.Entry<K, V> var1);

    public static <I, K extends Key<I>, V, M> CacheEntryScheduler<I, K, V, M> inactive() {
        return new InactiveCacheEntryScheduler();
    }

    public static <I, K extends Key<I>, V, M> CacheEntryScheduler<I, K, V, M> fromReference(Supplier<? extends CacheEntryScheduler<I, K, V, M>> reference) {
        return new ReferenceCacheEntryScheduler(reference);
    }

    public static class InactiveCacheEntryScheduler<I, K extends Key<I>, V, M>
    extends Scheduler.InactiveScheduler<I, M>
    implements CacheEntryScheduler<I, K, V, M> {
        @Override
        public void schedule(Map.Entry<K, V> entry) {
        }
    }

    public static class ReferenceCacheEntryScheduler<I, K extends Key<I>, V, M>
    extends Scheduler.ReferenceScheduler<I, M>
    implements CacheEntryScheduler<I, K, V, M> {
        private final Supplier<? extends CacheEntryScheduler<I, K, V, M>> reference;

        ReferenceCacheEntryScheduler(Supplier<? extends CacheEntryScheduler<I, K, V, M>> reference) {
            super(reference);
            this.reference = reference;
        }

        @Override
        public void schedule(Map.Entry<K, V> entry) {
            this.reference.get().schedule(entry);
        }
    }
}

