/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups;

import org.jgroups.Address;
import org.jgroups.JChannel;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.jgroups.ChannelGroup;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.server.jgroups.GroupProvider;
import org.wildfly.clustering.server.jgroups.JChannelFactory;
import org.wildfly.clustering.server.jgroups.JChannelGroup;

public class JChannelGroupProvider
implements GroupProvider<Address, ChannelGroupMember> {
    private final JChannel channel;
    private final ChannelGroup group;

    public JChannelGroupProvider(String clusterName, String memberName) throws Exception {
        this.channel = JChannelFactory.INSTANCE.apply(memberName);
        this.channel.connect(clusterName);
        this.group = new JChannelGroup(this.channel);
    }

    @Override
    public JChannel getChannel() {
        return this.channel;
    }

    @Override
    public Group<Address, ChannelGroupMember> getGroup() {
        return this.group;
    }

    @Override
    public String getName() {
        return this.channel.getClusterName();
    }

    @Override
    public void close() throws Exception {
        this.group.close();
        this.channel.disconnect();
        this.channel.close();
    }
}

