/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups.dispatcher;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.Group;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.dispatcher.CommandDispatcher;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.server.jgroups.dispatcher.CommandDispatcherFactoryProvider;
import org.wildfly.clustering.server.jgroups.dispatcher.test.IdentityCommand;
import org.wildfly.common.function.ExceptionBiFunction;

public abstract class CommandDispatcherITCase<M extends GroupMember> {
    private static final String CLUSTER_NAME = "cluster";
    private final ExceptionBiFunction<String, String, CommandDispatcherFactoryProvider<M>, Exception> factory;

    protected CommandDispatcherITCase(ExceptionBiFunction<String, String, CommandDispatcherFactoryProvider<M>, Exception> factory) {
        this.factory = factory;
    }

    @Test
    public void test() throws Exception {
        try (CommandDispatcherFactoryProvider provider1 = (CommandDispatcherFactoryProvider)this.factory.apply((Object)CLUSTER_NAME, (Object)"member1");){
            CommandDispatcherFactory factory1 = provider1.getCommandDispatcherFactory();
            Group group1 = factory1.getGroup();
            UUID fooContext1 = UUID.randomUUID();
            try (CommandDispatcher dispatcher1 = factory1.createCommandDispatcher((Object)"foo", (Object)fooContext1);){
                Assertions.assertSame((Object)fooContext1, (Object)dispatcher1.getContext());
                Assertions.assertSame((Object)fooContext1, dispatcher1.dispatchToMember(new IdentityCommand(), group1.getLocalMember()).toCompletableFuture().get());
                Map results = dispatcher1.dispatchToGroup(new IdentityCommand());
                Assertions.assertEquals((int)1, (int)results.size());
                Assertions.assertSame((Object)fooContext1, ((CompletionStage)results.get(group1.getLocalMember())).toCompletableFuture().get());
                Assertions.assertTrue((boolean)dispatcher1.dispatchToGroup(new IdentityCommand(), Set.of(group1.getLocalMember())).isEmpty());
                try (CommandDispatcherFactoryProvider provider2 = (CommandDispatcherFactoryProvider)this.factory.apply((Object)CLUSTER_NAME, (Object)"member2");){
                    CommandDispatcherFactory factory2 = provider2.getCommandDispatcherFactory();
                    Group group2 = factory2.getGroup();
                    UUID fooContext2 = UUID.randomUUID();
                    try (CommandDispatcher dispatcher2 = factory2.createCommandDispatcher((Object)"foo", (Object)fooContext2);){
                        Assertions.assertSame((Object)fooContext2, (Object)dispatcher2.getContext());
                        Assertions.assertSame((Object)fooContext2, dispatcher2.dispatchToMember(new IdentityCommand(), group2.getLocalMember()).toCompletableFuture().get());
                        Assertions.assertEquals((Object)fooContext1, dispatcher2.dispatchToMember(new IdentityCommand(), group1.getLocalMember()).toCompletableFuture().get());
                        results = dispatcher2.dispatchToGroup(new IdentityCommand());
                        Assertions.assertEquals((int)2, (int)results.size());
                        Assertions.assertEquals((Object)fooContext1, ((CompletionStage)results.get(group1.getLocalMember())).toCompletableFuture().get());
                        Assertions.assertEquals((Object)fooContext2, ((CompletionStage)results.get(group2.getLocalMember())).toCompletableFuture().get());
                        results = dispatcher2.dispatchToGroup(new IdentityCommand(), Set.of(group1.getLocalMember()));
                        Assertions.assertEquals((int)1, (int)results.size());
                        Assertions.assertSame((Object)fooContext2, ((CompletionStage)results.get(group2.getLocalMember())).toCompletableFuture().get());
                        results = dispatcher2.dispatchToGroup(new IdentityCommand(), Set.of(group2.getLocalMember()));
                        Assertions.assertEquals((int)1, (int)results.size());
                        Assertions.assertEquals((Object)fooContext1, ((CompletionStage)results.get(group1.getLocalMember())).toCompletableFuture().get());
                        Assertions.assertTrue((boolean)dispatcher2.dispatchToGroup(new IdentityCommand(), Set.of(group1.getLocalMember(), group2.getLocalMember())).isEmpty());
                    }
                    results = dispatcher1.dispatchToGroup(new IdentityCommand());
                    Assertions.assertEquals((int)2, (int)results.size());
                    Assertions.assertSame((Object)fooContext1, ((CompletionStage)results.get(group1.getLocalMember())).toCompletableFuture().get());
                    Assertions.assertThrows(CancellationException.class, ((CompletionStage)results.get(group2.getLocalMember())).toCompletableFuture()::get);
                    results = dispatcher1.dispatchToGroup(new IdentityCommand(), Set.of(group1.getLocalMember()));
                    Assertions.assertEquals((int)1, (int)results.size());
                    Assertions.assertThrows(CancellationException.class, ((CompletionStage)results.get(group2.getLocalMember())).toCompletableFuture()::get);
                    Assertions.assertThrows(CancellationException.class, dispatcher1.dispatchToMember(new IdentityCommand(), group2.getLocalMember()).toCompletableFuture()::get);
                    UUID barContext2 = UUID.randomUUID();
                    try (CommandDispatcher dispatcher2 = factory2.createCommandDispatcher((Object)"bar", (Object)barContext2);){
                        Assertions.assertSame((Object)barContext2, (Object)dispatcher2.getContext());
                        Assertions.assertSame((Object)barContext2, dispatcher2.dispatchToMember(new IdentityCommand(), group2.getLocalMember()).toCompletableFuture().get());
                        Assertions.assertThrows(CancellationException.class, dispatcher2.dispatchToMember(new IdentityCommand(), group1.getLocalMember()).toCompletableFuture()::get);
                        results = dispatcher2.dispatchToGroup(new IdentityCommand());
                        Assertions.assertEquals((int)2, (int)results.size());
                        Assertions.assertThrows(CancellationException.class, ((CompletionStage)results.get(group1.getLocalMember())).toCompletableFuture()::get);
                        Assertions.assertSame((Object)barContext2, ((CompletionStage)results.get(group2.getLocalMember())).toCompletableFuture().get());
                        results = dispatcher2.dispatchToGroup(new IdentityCommand(), Set.of(group2.getLocalMember()));
                        Assertions.assertEquals((int)1, (int)results.size());
                        Assertions.assertThrows(CancellationException.class, ((CompletionStage)results.get(group1.getLocalMember())).toCompletableFuture()::get);
                    }
                }
            }
        }
    }
}

