/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups;

import java.net.InetAddress;
import java.util.function.Function;
import org.jgroups.JChannel;

public enum JChannelFactory implements Function<String, JChannel>
{
    INSTANCE;

    static final String JGROUPS_CONFIG = "jgroups.xml";

    @Override
    public JChannel apply(String memberName) {
        try {
            JChannel channel = new JChannel(JGROUPS_CONFIG);
            channel.setName(memberName);
            return channel;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        System.setProperty("jgroups.bind_addr", InetAddress.getLoopbackAddress().getHostAddress());
    }
}

