/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.GroupMembership;
import org.wildfly.clustering.server.GroupMembershipEvent;
import org.wildfly.clustering.server.GroupMembershipListener;
import org.wildfly.clustering.server.GroupMembershipMergeEvent;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.group.GroupMember;
import org.wildfly.clustering.server.jgroups.GroupProvider;

public abstract class GroupITCase<A extends Comparable<A>, M extends GroupMember<A>> {
    private static final String CLUSTER_NAME = "cluster";
    private static final String[] MEMBER_NAMES = new String[]{"member0", "member1", "member2"};
    private static final Duration VIEW_CHANGE_DURATION = Duration.ofSeconds(20L);
    private static final Duration SPLIT_MERGE_DURATION = Duration.ofSeconds(120L);
    private final BiFunction<String, String, GroupProvider<A, M>> factory;
    private final Function<A, Address> mapper;

    protected GroupITCase(BiFunction<String, String, GroupProvider<A, M>> factory, Function<A, Address> mapper) {
        this.factory = factory;
        this.mapper = mapper;
    }

    @Test
    public void test() throws Exception {
        try (GroupProvider<A, M> provider1 = this.factory.apply(CLUSTER_NAME, MEMBER_NAMES[0]);){
            Group<A, M> group1 = provider1.getGroup();
            JChannel channel1 = provider1.getChannel();
            Assertions.assertThat((String)group1.getName()).isSameAs((Object)channel1.getClusterName());
            Assertions.assertThat((String)((GroupMember)group1.getLocalMember()).getName()).isEqualTo(MEMBER_NAMES[0]);
            Assertions.assertThat((boolean)group1.isSingleton()).isFalse();
            this.validate(channel1, group1);
            GroupMembership previousMembership = null;
            GroupMembership currentMembership = group1.getMembership();
            Assertions.assertThat((Comparable)((GroupMember)currentMembership.getCoordinator())).isEqualTo((Object)group1.getLocalMember());
            Assertions.assertThat((List)currentMembership.getMembers()).containsExactly((Object[])new GroupMember[]{(GroupMember)group1.getLocalMember()});
            final LinkedBlockingQueue updateEvents = new LinkedBlockingQueue();
            final LinkedBlockingQueue splitEvents = new LinkedBlockingQueue();
            final LinkedBlockingQueue mergeEvents = new LinkedBlockingQueue();
            GroupMembershipListener listener = new GroupMembershipListener<M>(){

                public void updated(GroupMembershipEvent<M> event) {
                    updateEvents.add(event);
                }

                public void split(GroupMembershipEvent<M> event) {
                    splitEvents.add(event);
                }

                public void merged(GroupMembershipMergeEvent<M> event) {
                    mergeEvents.add(event);
                }
            };
            try (Registration registration = group1.register((Object)listener);){
                GroupMembershipEvent updateEvent = (GroupMembershipEvent)updateEvents.poll();
                GroupMembershipEvent splitEvent = (GroupMembershipEvent)splitEvents.poll();
                GroupMembershipMergeEvent mergeEvent = (GroupMembershipMergeEvent)mergeEvents.poll();
                Assertions.assertThat((Object)updateEvent).isNull();
                Assertions.assertThat((Object)splitEvent).isNull();
                Assertions.assertThat((Object)mergeEvent).isNull();
                try (GroupProvider<A, M> provider2 = this.factory.apply(CLUSTER_NAME, MEMBER_NAMES[1]);){
                    JChannel channel2 = provider2.getChannel();
                    Assertions.assertThat((List)channel2.getView().getMembers()).containsExactly((Object[])new Address[]{channel1.getAddress(), channel2.getAddress()});
                    Instant start = Instant.now();
                    updateEvent = (GroupMembershipEvent)updateEvents.poll(VIEW_CHANGE_DURATION.toSeconds(), TimeUnit.SECONDS);
                    System.out.println("View change detected after " + String.valueOf(Duration.between(start, Instant.now())));
                    splitEvent = (GroupMembershipEvent)splitEvents.poll();
                    mergeEvent = (GroupMembershipMergeEvent)mergeEvents.poll();
                    Assertions.assertThat((Object)updateEvent).isNotNull();
                    Assertions.assertThat((Object)splitEvent).isNull();
                    Assertions.assertThat((Object)mergeEvent).isNull();
                    previousMembership = currentMembership;
                    currentMembership = group1.getMembership();
                    Assertions.assertThat((Object)updateEvent.getPreviousMembership()).isEqualTo((Object)previousMembership);
                    Assertions.assertThat((Object)updateEvent.getCurrentMembership()).isEqualTo((Object)currentMembership);
                    Group<A, M> group2 = provider2.getGroup();
                    Assertions.assertThat((String)group2.getName()).isSameAs((Object)channel2.getClusterName());
                    Assertions.assertThat((String)((GroupMember)group2.getLocalMember()).getName()).isEqualTo(MEMBER_NAMES[1]);
                    Assertions.assertThat((boolean)group2.isSingleton()).isFalse();
                    this.validate(channel1, group1);
                    this.validate(channel2, group2);
                    GroupMembership membership2 = group2.getMembership();
                    Assertions.assertThat((Object)membership2).isEqualTo((Object)currentMembership);
                    Assertions.assertThat((Comparable)((GroupMember)membership2.getCoordinator())).isEqualTo((Object)currentMembership.getCoordinator());
                    Assertions.assertThat((List)membership2.getMembers()).containsExactlyElementsOf((Iterable)currentMembership.getMembers());
                    try (GroupProvider<A, M> provider3 = this.factory.apply(CLUSTER_NAME, MEMBER_NAMES[2]);){
                        JChannel channel3 = provider3.getChannel();
                        Assertions.assertThat((List)channel3.getView().getMembers()).containsExactly((Object[])new Address[]{channel1.getAddress(), channel2.getAddress(), channel3.getAddress()});
                        start = Instant.now();
                        updateEvent = (GroupMembershipEvent)updateEvents.poll(VIEW_CHANGE_DURATION.toSeconds(), TimeUnit.SECONDS);
                        System.out.println("View change detected after " + String.valueOf(Duration.between(start, Instant.now())));
                        splitEvent = (GroupMembershipEvent)splitEvents.poll();
                        mergeEvent = (GroupMembershipMergeEvent)mergeEvents.poll();
                        Assertions.assertThat((Object)updateEvent).isNotNull();
                        Assertions.assertThat((Object)splitEvent).isNull();
                        Assertions.assertThat((Object)mergeEvent).isNull();
                        previousMembership = currentMembership;
                        currentMembership = group1.getMembership();
                        Assertions.assertThat((Object)updateEvent.getPreviousMembership()).isEqualTo((Object)previousMembership);
                        Assertions.assertThat((Object)updateEvent.getCurrentMembership()).isEqualTo((Object)currentMembership);
                        Group<A, M> group3 = provider3.getGroup();
                        Assertions.assertThat((String)group3.getName()).isSameAs((Object)channel3.getClusterName());
                        Assertions.assertThat((String)((GroupMember)group3.getLocalMember()).getName()).isEqualTo(MEMBER_NAMES[2]);
                        Assertions.assertThat((boolean)group3.isSingleton()).isFalse();
                        this.validate(channel1, group1);
                        this.validate(channel2, group2);
                        this.validate(channel3, group3);
                        GroupMembership membership3 = group3.getMembership();
                        Assertions.assertThat((Object)membership3).isEqualTo((Object)currentMembership);
                        Assertions.assertThat((Comparable)((GroupMember)membership3.getCoordinator())).isEqualTo((Object)currentMembership.getCoordinator());
                        Assertions.assertThat((List)membership3.getMembers()).containsExactlyElementsOf((Iterable)currentMembership.getMembers());
                        System.out.println("Simulating network partition");
                        DISCARD discard1 = new DISCARD().discardAll(true);
                        channel1.getProtocolStack().insertProtocol((Protocol)discard1, ProtocolStack.Position.ABOVE, TP.class);
                        start = Instant.now();
                        splitEvent = (GroupMembershipEvent)splitEvents.poll(SPLIT_MERGE_DURATION.toSeconds(), TimeUnit.SECONDS);
                        System.out.println("Network partition created after " + String.valueOf(Duration.between(start, Instant.now())));
                        updateEvent = (GroupMembershipEvent)updateEvents.poll();
                        mergeEvent = (GroupMembershipMergeEvent)mergeEvents.poll();
                        Assertions.assertThat((Object)updateEvent).isNull();
                        Assertions.assertThat((Object)splitEvent).isNotNull();
                        Assertions.assertThat((Object)mergeEvent).isNull();
                        this.validate(channel1, group1);
                        this.validate(channel2, group2);
                        this.validate(channel3, group3);
                        previousMembership = currentMembership;
                        currentMembership = group1.getMembership();
                        Assertions.assertThat((Object)splitEvent.getPreviousMembership()).isEqualTo((Object)previousMembership);
                        Assertions.assertThat((Object)splitEvent.getCurrentMembership()).isEqualTo((Object)currentMembership);
                        Assertions.assertThat((List)currentMembership.getMembers()).containsExactly((Object[])new GroupMember[]{(GroupMember)group1.getLocalMember()});
                        Assertions.assertThat((Comparable)((GroupMember)currentMembership.getCoordinator())).isEqualTo((Object)group1.getLocalMember());
                        System.out.println("Resolving network partition");
                        channel1.getProtocolStack().removeProtocol(DISCARD.class);
                        start = Instant.now();
                        mergeEvent = (GroupMembershipMergeEvent)mergeEvents.poll(SPLIT_MERGE_DURATION.toSeconds(), TimeUnit.SECONDS);
                        System.out.println("Network partition resolved after " + String.valueOf(Duration.between(start, Instant.now())));
                        splitEvent = (GroupMembershipEvent)splitEvents.poll();
                        updateEvent = (GroupMembershipEvent)updateEvents.poll();
                        Assertions.assertThat((Object)updateEvent).isNull();
                        Assertions.assertThat((Object)splitEvent).isNull();
                        Assertions.assertThat((Object)mergeEvent).isNotNull();
                        this.validate(channel1, group1);
                        this.validate(channel2, group2);
                        this.validate(channel3, group3);
                        previousMembership = currentMembership;
                        currentMembership = group1.getMembership();
                        Assertions.assertThat((Object)mergeEvent.getPreviousMembership()).isEqualTo((Object)previousMembership);
                        Assertions.assertThat((Object)mergeEvent.getCurrentMembership()).isEqualTo((Object)currentMembership);
                        Assertions.assertThat((List)currentMembership.getMembers()).containsExactlyInAnyOrder((Object[])new GroupMember[]{(GroupMember)group1.getLocalMember(), (GroupMember)group2.getLocalMember(), (GroupMember)group3.getLocalMember()});
                        ((ListAssert)Assertions.assertThat((List)mergeEvent.getPartitions()).hasSize(2)).contains((Object[])new GroupMembership[]{previousMembership});
                    }
                    start = Instant.now();
                    updateEvent = (GroupMembershipEvent)updateEvents.poll(VIEW_CHANGE_DURATION.toSeconds(), TimeUnit.SECONDS);
                    System.out.println("View change detected after " + String.valueOf(Duration.between(start, Instant.now())));
                    splitEvent = (GroupMembershipEvent)splitEvents.poll();
                    mergeEvent = (GroupMembershipMergeEvent)mergeEvents.poll();
                    Assertions.assertThat((Object)updateEvent).isNotNull();
                    Assertions.assertThat((Object)splitEvent).isNull();
                    Assertions.assertThat((Object)mergeEvent).isNull();
                    this.validate(channel1, group1);
                    this.validate(channel2, group2);
                    previousMembership = currentMembership;
                    currentMembership = group1.getMembership();
                    Assertions.assertThat((Object)updateEvent.getPreviousMembership()).isEqualTo((Object)previousMembership);
                    Assertions.assertThat((Object)updateEvent.getCurrentMembership()).isEqualTo((Object)currentMembership);
                    Assertions.assertThat((List)currentMembership.getMembers()).containsExactlyInAnyOrder((Object[])new GroupMember[]{(GroupMember)group1.getLocalMember(), (GroupMember)group2.getLocalMember()});
                }
                Instant start = Instant.now();
                updateEvent = (GroupMembershipEvent)updateEvents.poll(VIEW_CHANGE_DURATION.toSeconds(), TimeUnit.SECONDS);
                System.out.println("View change detected after " + String.valueOf(Duration.between(start, Instant.now())));
                splitEvent = (GroupMembershipEvent)splitEvents.poll();
                mergeEvent = (GroupMembershipMergeEvent)mergeEvents.poll();
                Assertions.assertThat((Object)updateEvent).isNotNull();
                Assertions.assertThat((Object)splitEvent).isNull();
                Assertions.assertThat((Object)mergeEvent).isNull();
                this.validate(channel1, group1);
                previousMembership = currentMembership;
                currentMembership = group1.getMembership();
                Assertions.assertThat((Object)updateEvent.getPreviousMembership()).isEqualTo((Object)previousMembership);
                Assertions.assertThat((Object)updateEvent.getCurrentMembership()).isEqualTo((Object)currentMembership);
                Assertions.assertThat((Comparable)((GroupMember)currentMembership.getCoordinator())).isEqualTo((Object)group1.getLocalMember());
                Assertions.assertThat((List)currentMembership.getMembers()).containsExactly((Object[])new GroupMember[]{(GroupMember)group1.getLocalMember()});
            }
        }
    }

    private void validate(JChannel channel, Group<A, M> group) {
        Assertions.assertThat((String)((GroupMember)group.getLocalMember()).getName()).isEqualTo(channel.getName());
        Assertions.assertThat((Comparable)this.mapper.apply(((GroupMember)group.getLocalMember()).getAddress())).isEqualTo((Object)channel.getAddress());
        View view = channel.getView();
        GroupMembership membership = group.getMembership();
        Assertions.assertThat((Comparable)this.mapper.apply(((GroupMember)membership.getCoordinator()).getAddress())).isEqualTo((Object)view.getCoord());
        Assertions.assertThat(membership.getMembers().stream().map(GroupMember::getAddress).map(this.mapper).toList()).containsExactlyElementsOf((Iterable)view.getMembers());
    }
}

