/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups;

import org.jgroups.Address;
import org.jgroups.JChannel;
import org.wildfly.clustering.server.AutoCloseableProvider;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.jgroups.ChannelGroup;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.server.jgroups.GroupProvider;
import org.wildfly.clustering.server.jgroups.JChannelFactory;
import org.wildfly.clustering.server.jgroups.JChannelGroup;

public class JChannelGroupProvider
extends AutoCloseableProvider
implements GroupProvider<Address, ChannelGroupMember> {
    private final JChannel channel;
    private final ChannelGroup group;

    public JChannelGroupProvider(String clusterName, String memberName) {
        this.channel = JChannelFactory.INSTANCE.apply(memberName);
        this.accept(() -> ((JChannel)this.channel).close());
        try {
            this.channel.connect(clusterName);
            this.accept(() -> ((JChannel)this.channel).disconnect());
            this.group = new JChannelGroup(this.channel);
            this.accept(() -> ((ChannelGroup)this.group).close());
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JChannel getChannel() {
        return this.channel;
    }

    @Override
    public Group<Address, ChannelGroupMember> getGroup() {
        return this.group;
    }

    @Override
    public void close() {
        this.group.close();
        this.channel.disconnect();
        this.channel.close();
    }
}

