/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups.dispatcher;

import java.util.function.Function;
import java.util.function.Predicate;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.server.AutoCloseableProvider;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.server.jgroups.JChannelFactory;
import org.wildfly.clustering.server.jgroups.dispatcher.ChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.jgroups.dispatcher.CommandDispatcherFactoryProvider;
import org.wildfly.clustering.server.jgroups.dispatcher.JChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.jgroups.dispatcher.JChannelCommandDispatcherFactoryConfiguration;

public class ChannelCommandDispatcherFactoryProvider
extends AutoCloseableProvider
implements CommandDispatcherFactoryProvider<ChannelGroupMember>,
JChannelCommandDispatcherFactoryConfiguration {
    private final ByteBufferMarshaller marshaller = new ProtoStreamTesterFactory().getMarshaller();
    private final JChannel channel;
    private final ChannelCommandDispatcherFactory factory;

    public ChannelCommandDispatcherFactoryProvider(String clusterName, String memberName) {
        this.channel = JChannelFactory.INSTANCE.apply(memberName);
        this.accept(() -> ((JChannel)this.channel).close());
        try {
            this.channel.connect(clusterName);
            this.accept(() -> ((JChannel)this.channel).disconnect());
            this.factory = new JChannelCommandDispatcherFactory((JChannelCommandDispatcherFactoryConfiguration)this);
            this.accept(() -> ((ChannelCommandDispatcherFactory)this.factory).close());
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ChannelCommandDispatcherFactory getCommandDispatcherFactory() {
        return this.factory;
    }

    public Predicate<Message> getUnknownForkPredicate() {
        return Predicate.not(Message::hasPayload);
    }

    public JChannel getChannel() {
        return this.channel;
    }

    public ByteBufferMarshaller getMarshaller() {
        return this.marshaller;
    }

    public Function<ClassLoader, ByteBufferMarshaller> getMarshallerFactory() {
        return org.wildfly.clustering.function.Function.of((Object)this.marshaller);
    }
}

