/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups;

import java.util.function.Function;
import org.jgroups.EmptyMessage;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.fork.ForkChannel;
import org.jgroups.fork.UnknownForkHandler;
import org.jgroups.protocols.FORK;
import org.jgroups.stack.Protocol;

public class ForkChannelFactory
implements Function<String, JChannel> {
    private final JChannel channel;

    public ForkChannelFactory(JChannel channel) {
        final FORK fork = new FORK();
        channel.getProtocolStack().addProtocol((Protocol)fork.setUnknownForkHandler(new UnknownForkHandler(){
            private final short id = ClassConfigurator.getProtocolId(RequestCorrelator.class);

            public Object handleUnknownForkStack(Message message, String forkStackId) {
                return this.handle(message);
            }

            public Object handleUnknownForkChannel(Message message, String forkChannelId) {
                return this.handle(message);
            }

            private Object handle(Message message) {
                RequestCorrelator.Header header = (RequestCorrelator.Header)message.getHeader(this.id);
                if (header != null && header.type == 0 && header.rspExpected()) {
                    Message response = new EmptyMessage(message.src()).setFlag(message.getFlags(), false).clearFlag(new Message.Flag[]{Message.Flag.RSVP});
                    if (message.getDest() != null) {
                        response.src(message.getDest());
                    }
                    response.putHeader(FORK.ID, message.getHeader(FORK.ID));
                    response.putHeader(this.id, (Header)new RequestCorrelator.Header(1, header.req_id, header.corrId));
                    fork.getProtocolStack().getChannel().down(response);
                }
                return null;
            }
        }));
        this.channel = channel;
    }

    @Override
    public JChannel apply(String fork) {
        try {
            return new ForkChannel(this.channel, this.channel.getClusterName(), fork, new Protocol[0]){

                public ForkChannel setName(String name) {
                    return this;
                }

                public JChannel name(String name) {
                    return this;
                }
            };
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

