/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.local.scheduler;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.wildfly.clustering.server.local.scheduler.LinkedScheduledEntries;
import org.wildfly.clustering.server.local.scheduler.SortedScheduledEntries;

public interface ScheduledEntries<K, V>
extends Iterable<Map.Entry<K, V>> {
    public boolean isSorted();

    public void add(K var1, V var2);

    public void remove(K var1);

    public boolean contains(K var1);

    default public Map.Entry<K, V> peek() {
        return this.stream().findFirst().orElse(null);
    }

    public Stream<Map.Entry<K, V>> stream();

    @Override
    default public Iterator<Map.Entry<K, V>> iterator() {
        return this.stream().iterator();
    }

    public static <K, V> ScheduledEntries<K, V> linked() {
        return new LinkedScheduledEntries();
    }

    public static <K extends Comparable<? super K>, V extends Comparable<? super V>> ScheduledEntries<K, V> sorted() {
        return ScheduledEntries.sorted(SortedScheduledEntries.defaultComparator());
    }

    public static <K, V> ScheduledEntries<K, V> sorted(Comparator<Map.Entry<K, V>> comparator) {
        return new SortedScheduledEntries<K, V>(comparator);
    }
}

