/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.local.scheduler;

import java.security.AccessController;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.wildfly.clustering.context.DefaultExecutorService;
import org.wildfly.clustering.server.local.scheduler.LocalSchedulerConfiguration;
import org.wildfly.clustering.server.local.scheduler.ScheduledEntries;
import org.wildfly.clustering.server.scheduler.Scheduler;

public class LocalScheduler<T>
implements Scheduler<T, Instant>,
Runnable {
    private final ScheduledExecutorService executor;
    private final ScheduledEntries<T, Instant> entries;
    private final Predicate<T> task;
    private final Duration closeTimeout;
    private volatile Map.Entry<Map.Entry<T, Instant>, Future<?>> futureEntry = null;

    public LocalScheduler(LocalSchedulerConfiguration<T> configuration) {
        this.entries = configuration.getScheduledEntriesFactory().get();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, configuration.getThreadFactory());
        executor.setKeepAliveTime(1L, TimeUnit.MINUTES);
        executor.allowCoreThreadTimeOut(true);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        executor.setRemoveOnCancelPolicy(this.entries.isSorted());
        this.executor = executor;
        this.task = configuration.getTask();
        this.closeTimeout = configuration.getCloseTimeout();
    }

    public void schedule(T id, Instant instant) {
        this.entries.add(id, instant);
        if (this.entries.isSorted()) {
            this.rescheduleIfEarlier(instant);
        }
        this.scheduleIfAbsent();
    }

    public void cancel(T id) {
        if (this.entries.isSorted()) {
            this.cancelIfPresent(id);
        }
        this.entries.remove(id);
        if (this.entries.isSorted()) {
            this.scheduleIfAbsent();
        }
    }

    public boolean contains(T id) {
        return this.entries.contains(id);
    }

    public Stream<T> stream() {
        return this.entries.stream().map(Map.Entry::getKey);
    }

    public void close() {
        AccessController.doPrivileged(DefaultExecutorService.shutdown((ExecutorService)this.executor));
        if (!this.closeTimeout.isNegative() && !this.closeTimeout.isZero()) {
            try {
                this.executor.awaitTermination(this.closeTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Iterator<Map.Entry<T, Instant>> entries = this.entries.iterator();
        while (entries.hasNext()) {
            if (Thread.currentThread().isInterrupted() || this.executor.isShutdown()) {
                return;
            }
            Map.Entry<T, Instant> entry = entries.next();
            if (entry.getValue().isAfter(Instant.now())) break;
            T key = entry.getKey();
            if (!this.task.test(key)) continue;
            entries.remove();
        }
        LocalScheduler localScheduler = this;
        synchronized (localScheduler) {
            this.futureEntry = this.scheduleFirst();
        }
    }

    private Map.Entry<Map.Entry<T, Instant>, Future<?>> scheduleFirst() {
        Map.Entry<T, Instant> entry = this.entries.peek();
        return entry != null ? this.schedule(entry) : null;
    }

    private Map.Entry<Map.Entry<T, Instant>, Future<?>> schedule(Map.Entry<T, Instant> entry) {
        Duration delay = Duration.between(Instant.now(), entry.getValue());
        long millis = !delay.isNegative() ? delay.toMillis() + 1L : 0L;
        try {
            ScheduledFuture<?> future = this.executor.schedule(this, millis, TimeUnit.MILLISECONDS);
            return new AbstractMap.SimpleImmutableEntry(entry, future);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleIfAbsent() {
        if (this.futureEntry == null) {
            LocalScheduler localScheduler = this;
            synchronized (localScheduler) {
                if (this.futureEntry == null) {
                    this.futureEntry = this.scheduleFirst();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleIfEarlier(Instant instant) {
        if (this.futureEntry != null) {
            LocalScheduler localScheduler = this;
            synchronized (localScheduler) {
                if (this.futureEntry != null && instant.isBefore(this.futureEntry.getKey().getValue())) {
                    this.futureEntry.getValue().cancel(true);
                    this.futureEntry = this.scheduleFirst();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelIfPresent(T id) {
        if (this.futureEntry != null) {
            LocalScheduler localScheduler = this;
            synchronized (localScheduler) {
                if (this.futureEntry != null && this.futureEntry.getKey().getKey().equals(id)) {
                    this.futureEntry.getValue().cancel(true);
                    this.futureEntry = null;
                }
            }
        }
    }

    public String toString() {
        return this.entries.toString();
    }
}

