/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.local.scheduler;

import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.UnaryOperator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.local.scheduler.ScheduledEntries;

public abstract class AbstractScheduledEntriesTestCase {
    private final ScheduledEntries<UUID, Instant> entrySet;
    private final UnaryOperator<List<Map.Entry<UUID, Instant>>> expectedFactory;

    AbstractScheduledEntriesTestCase(ScheduledEntries<UUID, Instant> entrySet, UnaryOperator<List<Map.Entry<UUID, Instant>>> expectedFactory) {
        this.entrySet = entrySet;
        this.expectedFactory = expectedFactory;
    }

    @Test
    public void test() {
        Assertions.assertThat(this.entrySet).isEmpty();
        LinkedList<AbstractMap.SimpleImmutableEntry<UUID, Instant>> entries = new LinkedList<AbstractMap.SimpleImmutableEntry<UUID, Instant>>();
        Instant now = Instant.now();
        entries.add(new AbstractMap.SimpleImmutableEntry<UUID, Instant>(UUID.randomUUID(), now));
        entries.add(new AbstractMap.SimpleImmutableEntry<UUID, Instant>(UUID.randomUUID(), now));
        entries.add(new AbstractMap.SimpleImmutableEntry<UUID, Instant>(UUID.randomUUID(), now.minus(Duration.ofSeconds(1L))));
        entries.add(new AbstractMap.SimpleImmutableEntry<UUID, Instant>(UUID.randomUUID(), now.plus(Duration.ofSeconds(2L))));
        entries.add(new AbstractMap.SimpleImmutableEntry<UUID, Instant>(UUID.randomUUID(), now.plus(Duration.ofSeconds(1L))));
        for (Map.Entry entry : entries) {
            this.entrySet.add((Object)((UUID)entry.getKey()), (Object)((Instant)entry.getValue()));
        }
        List expected = (List)this.expectedFactory.apply(entries);
        Assertions.assertThat(this.entrySet).containsExactlyElementsOf((Iterable)expected);
        this.entrySet.remove((Object)((UUID)((Map.Entry)expected.remove(0)).getKey()));
        Assertions.assertThat(this.entrySet).containsExactlyElementsOf((Iterable)expected);
        this.entrySet.remove((Object)((UUID)((Map.Entry)expected.remove((expected.size() - 1) / 2)).getKey()));
        Assertions.assertThat(this.entrySet).containsExactlyElementsOf((Iterable)expected);
        this.entrySet.remove((Object)((UUID)((Map.Entry)expected.remove(expected.size() - 1)).getKey()));
        Assertions.assertThat(this.entrySet).containsExactlyElementsOf((Iterable)expected);
        this.entrySet.remove((Object)UUID.randomUUID());
        Assertions.assertThat(this.entrySet).containsExactlyElementsOf((Iterable)expected);
    }
}

