/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.local.scheduler;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadFactory;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.server.local.scheduler.LocalScheduler;
import org.wildfly.clustering.server.local.scheduler.LocalSchedulerConfiguration;
import org.wildfly.clustering.server.local.scheduler.ScheduledEntries;

public class LocalSchedulerTestCase {
    static LocalSchedulerConfiguration<UUID> configuration(final ScheduledEntries<UUID, Instant> entries, final Predicate<UUID> task) {
        return new LocalSchedulerConfiguration<UUID>(){

            public String getName() {
                return "test";
            }

            public ScheduledEntries<UUID, Instant> getScheduledEntries() {
                return entries;
            }

            public Predicate<UUID> getTask() {
                return task;
            }

            public ThreadFactory getThreadFactory() {
                return Thread::new;
            }

            public Duration getCloseTimeout() {
                return Duration.ZERO;
            }
        };
    }

    @Test
    public void successfulTask() throws InterruptedException {
        ScheduledEntries entries = (ScheduledEntries)Mockito.mock(ScheduledEntries.class);
        Predicate task = (Predicate)Mockito.mock(Predicate.class);
        Map.Entry<UUID, Instant> entry = Map.entry(UUID.randomUUID(), Instant.now());
        Object nullEntry = null;
        ArrayList<Map.Entry<UUID, Instant>> entryList = new ArrayList<Map.Entry<UUID, Instant>>(1);
        entryList.add(entry);
        try (LocalScheduler scheduler = new LocalScheduler(LocalSchedulerTestCase.configuration((ScheduledEntries<UUID, Instant>)entries, task));){
            Mockito.when((Object)entries.peek()).thenReturn(entry, (Object[])new Map.Entry[]{nullEntry});
            Mockito.when((Object)entries.iterator()).thenAnswer(invocation -> entryList.iterator());
            Mockito.when((Object)task.test(entry.getKey())).thenReturn((Object)true);
            scheduler.schedule((Object)entry.getKey(), (Object)entry.getValue());
            ((ScheduledEntries)Mockito.verify((Object)entries)).add((Object)entry.getKey(), (Object)entry.getValue());
            Thread.sleep(500L);
            Assertions.assertThat(entryList).isEmpty();
        }
    }

    @Test
    public void failingTask() throws InterruptedException {
        ScheduledEntries entries = (ScheduledEntries)Mockito.mock(ScheduledEntries.class);
        Predicate task = (Predicate)Mockito.mock(Predicate.class);
        Map.Entry<UUID, Instant> entry = Map.entry(UUID.randomUUID(), Instant.now());
        Object nullEntry = null;
        ArrayList<Map.Entry<UUID, Instant>> entryList = new ArrayList<Map.Entry<UUID, Instant>>(1);
        entryList.add(entry);
        try (LocalScheduler scheduler = new LocalScheduler(LocalSchedulerTestCase.configuration((ScheduledEntries<UUID, Instant>)entries, task));){
            Mockito.when((Object)entries.peek()).thenReturn(entry, (Object[])new Map.Entry[]{nullEntry});
            Mockito.when((Object)entries.iterator()).thenAnswer(invocation -> entryList.iterator());
            Mockito.when((Object)task.test(entry.getKey())).thenReturn((Object)false);
            scheduler.schedule((Object)entry.getKey(), (Object)entry.getValue());
            ((ScheduledEntries)Mockito.verify((Object)entries)).add((Object)entry.getKey(), (Object)entry.getValue());
            Thread.sleep(500L);
            Assertions.assertThat(entryList).isNotEmpty();
        }
    }

    @Test
    public void retryUntilSuccessfulTask() throws InterruptedException {
        ScheduledEntries entries = (ScheduledEntries)Mockito.mock(ScheduledEntries.class);
        Predicate task = (Predicate)Mockito.mock(Predicate.class);
        Map.Entry<UUID, Instant> entry = Map.entry(UUID.randomUUID(), Instant.now());
        ArrayList<Map.Entry<UUID, Instant>> entryList = new ArrayList<Map.Entry<UUID, Instant>>(1);
        entryList.add(entry);
        try (LocalScheduler scheduler = new LocalScheduler(LocalSchedulerTestCase.configuration((ScheduledEntries<UUID, Instant>)entries, task));){
            Mockito.when((Object)entries.peek()).thenReturn(entry, (Object[])new Map.Entry[]{entry, null});
            Mockito.when((Object)entries.iterator()).thenAnswer(invocation -> entryList.iterator());
            Mockito.when((Object)task.test(entry.getKey())).thenReturn((Object)false, (Object[])new Boolean[]{true});
            scheduler.schedule((Object)entry.getKey(), (Object)entry.getValue());
            ((ScheduledEntries)Mockito.verify((Object)entries)).add((Object)entry.getKey(), (Object)entry.getValue());
            Thread.sleep(500L);
            Assertions.assertThat(entryList).isEmpty();
        }
    }

    @Test
    public void cancel() {
        ScheduledEntries entries = (ScheduledEntries)Mockito.mock(ScheduledEntries.class);
        Predicate task = (Predicate)Mockito.mock(Predicate.class);
        Map.Entry<UUID, Instant> entry = Map.entry(UUID.randomUUID(), Instant.now());
        try (LocalScheduler scheduler = new LocalScheduler(LocalSchedulerTestCase.configuration((ScheduledEntries<UUID, Instant>)entries, task));){
            Mockito.when((Object)entries.peek()).thenReturn(entry);
            scheduler.cancel((Object)entry.getKey());
            ((ScheduledEntries)Mockito.verify((Object)entries)).remove((Object)entry.getKey());
        }
    }
}

