/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.context;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.context.Context;
import org.wildfly.clustering.server.context.ContextStrategy;
import org.wildfly.clustering.server.manager.Restartable;

public class ContextTestCase {
    private static final int KEYS = 10;
    private static final int SIZE = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shared() throws InterruptedException, ExecutionException {
        Context manager = ContextStrategy.SHARED.createContext(Restartable::start, Restartable::stop);
        ArrayList keyFutures = new ArrayList(10);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            for (int i = 0; i < 10; ++i) {
                ArrayList<Future<ManagedObject>> arrayList = new ArrayList<Future<ManagedObject>>(100);
                keyFutures.add(arrayList);
                for (int j = 0; j < 100; ++j) {
                    int n = i;
                    Callable<ManagedObject> task = () -> {
                        try (ManagedObject object = (ManagedObject)manager.computeIfAbsent((Object)key, ManagedObject::new);){
                            Assertions.assertTrue((boolean)object.isStarted());
                            Assertions.assertFalse((boolean)object.isStopped());
                            Thread.sleep(10L);
                            ManagedObject managedObject = object;
                            return managedObject;
                        }
                    };
                    arrayList.add(executor.submit(task));
                }
            }
            for (List list : keyFutures) {
                for (Future future : list) {
                    future.get();
                }
            }
            for (List list : keyFutures) {
                for (Future future : list) {
                    ManagedObject object = (ManagedObject)future.get();
                    Assertions.assertTrue((boolean)object.isStarted(), object::toString);
                    Assertions.assertTrue((boolean)object.isStopped(), object::toString);
                }
            }
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void unshared() {
        Context context = ContextStrategy.UNSHARED.createContext(Restartable::start, Restartable::stop);
        ManagedObject object = (ManagedObject)context.computeIfAbsent((Object)"foo", ManagedObject::new);
        try {
            Assertions.assertTrue((boolean)object.isStarted());
            Assertions.assertFalse((boolean)object.isStopped());
            try (ManagedObject object2 = (ManagedObject)context.computeIfAbsent((Object)"foo", ManagedObject::new);){
                Assertions.assertNotSame((Object)object2, (Object)object);
                Assertions.assertTrue((boolean)object2.isStarted());
                Assertions.assertFalse((boolean)object2.isStopped());
            }
        }
        finally {
            Assertions.assertTrue((boolean)object.isStarted());
            Assertions.assertFalse((boolean)object.isStopped());
            object.close();
            Assertions.assertTrue((boolean)object.isStarted());
            Assertions.assertTrue((boolean)object.isStopped());
        }
    }

    static class ManagedObject<I>
    implements Restartable,
    AutoCloseable {
        private volatile boolean started = false;
        private volatile boolean stopped = false;
        private final I id;
        private final Runnable closeTask;

        ManagedObject(I id, Runnable closeTask) {
            this.id = id;
            this.closeTask = closeTask;
        }

        public I getId() {
            return this.id;
        }

        public void start() {
            this.started = true;
        }

        public void stop() {
            this.stopped = true;
        }

        boolean isStarted() {
            return this.started;
        }

        boolean isStopped() {
            return this.stopped;
        }

        @Override
        public void close() {
            this.closeTask.run();
        }
    }
}

