/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.util;

import java.time.Duration;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.server.util.Invoker;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;

public class InvokerTestCase {
    @Test
    public void testSupplier() throws Exception {
        Throwable[] exceptions = new Exception[3];
        for (int i = 0; i < exceptions.length; ++i) {
            exceptions[i] = new Exception();
        }
        Object expected = new Object();
        ExceptionSupplier action = (ExceptionSupplier)Mockito.mock(ExceptionSupplier.class);
        Invoker invoker = Invoker.retrying(List.of(Duration.ZERO, Duration.ofMillis(1L)));
        Mockito.when((Object)action.get()).thenReturn(expected);
        Object result = invoker.invoke(action);
        Assertions.assertSame((Object)expected, (Object)result);
        Mockito.when((Object)action.get()).thenThrow(new Throwable[]{exceptions[0]}).thenReturn(expected);
        result = invoker.invoke(action);
        Assertions.assertSame((Object)expected, (Object)result);
        Mockito.when((Object)action.get()).thenThrow(new Throwable[]{exceptions[0], exceptions[1]}).thenReturn(expected);
        result = invoker.invoke(action);
        Assertions.assertSame((Object)expected, (Object)result);
        Mockito.when((Object)action.get()).thenThrow(exceptions).thenReturn(expected);
        try {
            result = invoker.invoke(action);
            Assertions.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assertions.assertSame((Object)exceptions[2], (Object)e);
        }
    }

    @Test
    public void testRunnable() throws Exception {
        Throwable[] exceptions = new Exception[3];
        for (int i = 0; i < exceptions.length; ++i) {
            exceptions[i] = new Exception();
        }
        ExceptionRunnable action = (ExceptionRunnable)Mockito.mock(ExceptionRunnable.class);
        ((ExceptionRunnable)Mockito.doNothing().when((Object)action)).run();
        Invoker invoker = Invoker.retrying(List.of(Duration.ZERO, Duration.ZERO));
        invoker.invoke(action);
        ((ExceptionRunnable)Mockito.doThrow((Throwable[])new Throwable[]{exceptions[0]}).doNothing().when((Object)action)).run();
        invoker.invoke(action);
        ((ExceptionRunnable)Mockito.doThrow((Throwable[])new Throwable[]{exceptions[0], exceptions[1]}).doNothing().when((Object)action)).run();
        invoker.invoke(action);
        ((ExceptionRunnable)Mockito.doThrow((Throwable[])exceptions).doNothing().when((Object)action)).run();
        try {
            invoker.invoke(action);
            Assertions.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assertions.assertSame((Object)exceptions[2], (Object)e);
        }
    }
}

