/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.immutable;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.FileSystems;
import java.security.AllPermission;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.temporal.ValueRange;
import java.time.temporal.WeekFields;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneRules;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.Immutable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.immutable.DefaultImmutability;
import org.wildfly.clustering.server.immutable.Immutability;

public class ImmutabilityTestCase {
    @Test
    public void test() throws Exception {
        this.test(Immutability.composite(EnumSet.allOf(DefaultImmutability.class)));
    }

    protected void test(Immutability immutability) throws Exception {
        Assertions.assertFalse((boolean)immutability.test(new Object()));
        Assertions.assertFalse((boolean)immutability.test((Object)new Date()));
        Assertions.assertFalse((boolean)immutability.test((Object)new AtomicInteger()));
        Assertions.assertFalse((boolean)immutability.test((Object)new AtomicLong()));
        Assertions.assertTrue((boolean)immutability.test(null));
        Assertions.assertTrue((boolean)immutability.test(Collections.emptyEnumeration()));
        Assertions.assertTrue((boolean)immutability.test(Collections.emptyIterator()));
        Assertions.assertTrue((boolean)immutability.test(Collections.emptyList()));
        Assertions.assertTrue((boolean)immutability.test(Collections.emptyListIterator()));
        Assertions.assertTrue((boolean)immutability.test(Collections.emptyMap()));
        Assertions.assertTrue((boolean)immutability.test(Collections.emptyNavigableMap()));
        Assertions.assertTrue((boolean)immutability.test(Collections.emptyNavigableSet()));
        Assertions.assertTrue((boolean)immutability.test(Collections.emptySet()));
        Assertions.assertTrue((boolean)immutability.test(Collections.emptySortedMap()));
        Assertions.assertTrue((boolean)immutability.test(Collections.emptySortedSet()));
        Assertions.assertTrue((boolean)immutability.test((Object)Boolean.TRUE));
        Assertions.assertTrue((boolean)immutability.test((Object)Character.valueOf('a')));
        Assertions.assertTrue((boolean)immutability.test(this.getClass()));
        Assertions.assertTrue((boolean)immutability.test((Object)Currency.getInstance(Locale.US)));
        Assertions.assertTrue((boolean)immutability.test((Object)Locale.getDefault()));
        Assertions.assertTrue((boolean)immutability.test((Object)Integer.valueOf(1).byteValue()));
        Assertions.assertTrue((boolean)immutability.test((Object)Integer.valueOf(1).shortValue()));
        Assertions.assertTrue((boolean)immutability.test((Object)1));
        Assertions.assertTrue((boolean)immutability.test((Object)1L));
        Assertions.assertTrue((boolean)immutability.test((Object)Float.valueOf(1.0f)));
        Assertions.assertTrue((boolean)immutability.test((Object)1.0));
        Assertions.assertTrue((boolean)immutability.test((Object)BigInteger.valueOf(1L)));
        Assertions.assertTrue((boolean)immutability.test((Object)BigDecimal.valueOf(1L)));
        Assertions.assertTrue((boolean)immutability.test((Object)InetAddress.getLocalHost()));
        Assertions.assertTrue((boolean)immutability.test((Object)new InetSocketAddress(InetAddress.getLocalHost(), 80)));
        Assertions.assertTrue((boolean)immutability.test((Object)MathContext.UNLIMITED));
        Assertions.assertTrue((boolean)immutability.test((Object)"test"));
        Assertions.assertTrue((boolean)immutability.test((Object)TimeZone.getDefault()));
        Assertions.assertTrue((boolean)immutability.test((Object)UUID.randomUUID()));
        Assertions.assertTrue((boolean)immutability.test((Object)TimeUnit.DAYS));
        File file = new File(System.getProperty("user.home"));
        Assertions.assertTrue((boolean)immutability.test((Object)file));
        Assertions.assertTrue((boolean)immutability.test((Object)file.toURI()));
        Assertions.assertTrue((boolean)immutability.test((Object)file.toURI().toURL()));
        Assertions.assertTrue((boolean)immutability.test((Object)FileSystems.getDefault().getRootDirectories().iterator().next()));
        Assertions.assertTrue((boolean)immutability.test((Object)new AllPermission()));
        Assertions.assertTrue((boolean)immutability.test((Object)DateTimeFormatter.BASIC_ISO_DATE));
        Assertions.assertTrue((boolean)immutability.test((Object)DecimalStyle.STANDARD));
        Assertions.assertTrue((boolean)immutability.test((Object)Duration.ZERO));
        Assertions.assertTrue((boolean)immutability.test((Object)Instant.now()));
        Assertions.assertTrue((boolean)immutability.test((Object)LocalDate.now()));
        Assertions.assertTrue((boolean)immutability.test((Object)LocalDateTime.now()));
        Assertions.assertTrue((boolean)immutability.test((Object)LocalTime.now()));
        Assertions.assertTrue((boolean)immutability.test((Object)MonthDay.now()));
        Assertions.assertTrue((boolean)immutability.test((Object)Period.ZERO));
        Assertions.assertTrue((boolean)immutability.test((Object)ValueRange.of(0L, 10L)));
        Assertions.assertTrue((boolean)immutability.test((Object)WeekFields.ISO));
        Assertions.assertTrue((boolean)immutability.test((Object)Year.now()));
        Assertions.assertTrue((boolean)immutability.test((Object)YearMonth.now()));
        Assertions.assertTrue((boolean)immutability.test((Object)ZoneOffset.UTC));
        Assertions.assertTrue((boolean)immutability.test((Object)ZoneRules.of(ZoneOffset.UTC).nextTransition(Instant.now())));
        Assertions.assertTrue((boolean)immutability.test((Object)ZoneOffsetTransitionRule.of(Month.JANUARY, 1, DayOfWeek.SUNDAY, LocalTime.MIDNIGHT, true, ZoneOffsetTransitionRule.TimeDefinition.STANDARD, ZoneOffset.UTC, ZoneOffset.ofHours(1), ZoneOffset.ofHours(2))));
        Assertions.assertTrue((boolean)immutability.test((Object)ZoneRules.of(ZoneOffset.UTC)));
        Assertions.assertTrue((boolean)immutability.test((Object)ZonedDateTime.now()));
        Assertions.assertTrue((boolean)immutability.test((Object)new JCIPImmutableObject()));
        Assertions.assertTrue((boolean)immutability.test(Collections.singleton("1")));
        Assertions.assertTrue((boolean)immutability.test(Collections.singletonList("1")));
        Assertions.assertTrue((boolean)immutability.test(Collections.singletonMap("1", "2")));
        Assertions.assertTrue((boolean)immutability.test(Collections.singleton(new JCIPImmutableObject())));
        Assertions.assertTrue((boolean)immutability.test(Collections.singletonList(new JCIPImmutableObject())));
        Assertions.assertTrue((boolean)immutability.test(Collections.singletonMap("1", new JCIPImmutableObject())));
        Assertions.assertTrue((boolean)immutability.test(new AbstractMap.SimpleImmutableEntry<String, JCIPImmutableObject>("1", new JCIPImmutableObject())));
        Assertions.assertTrue((boolean)immutability.test(Collections.unmodifiableCollection(Arrays.asList("1", "2"))));
        Assertions.assertTrue((boolean)immutability.test(Collections.unmodifiableList(Arrays.asList("1", "2"))));
        Assertions.assertTrue((boolean)immutability.test(Collections.unmodifiableMap(Collections.singletonMap("1", "2"))));
        Assertions.assertTrue((boolean)immutability.test(Collections.unmodifiableNavigableMap(new TreeMap<String, String>(Collections.singletonMap("1", "2")))));
        Assertions.assertTrue((boolean)immutability.test(Collections.unmodifiableNavigableSet(new TreeSet<String>(Collections.singleton("1")))));
        Assertions.assertTrue((boolean)immutability.test(Collections.unmodifiableSet(Collections.singleton("1"))));
        Assertions.assertTrue((boolean)immutability.test(Collections.unmodifiableSortedMap(new TreeMap<String, String>(Collections.singletonMap("1", "2")))));
        Assertions.assertTrue((boolean)immutability.test(Collections.unmodifiableSortedSet(new TreeSet<String>(Collections.singleton("1")))));
        Assertions.assertTrue((boolean)immutability.test(List.of()));
        Assertions.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1))));
        Assertions.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2))));
        Assertions.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))));
        Assertions.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4))));
        Assertions.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5))));
        Assertions.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6))));
        Assertions.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7))));
        Assertions.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8))));
        Assertions.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9))));
        Assertions.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9), Integer.valueOf(10))));
        Assertions.assertTrue((boolean)immutability.test(List.of(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)));
        Assertions.assertTrue((boolean)immutability.test(Set.of()));
        Assertions.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1))));
        Assertions.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2))));
        Assertions.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))));
        Assertions.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4))));
        Assertions.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5))));
        Assertions.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6))));
        Assertions.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7))));
        Assertions.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8))));
        Assertions.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9))));
        Assertions.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9), Integer.valueOf(10))));
        Assertions.assertTrue((boolean)immutability.test(Set.of(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)));
        Assertions.assertTrue((boolean)immutability.test(Map.of()));
        Assertions.assertTrue((boolean)immutability.test(Map.of(1, "1")));
        Assertions.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2")));
        Assertions.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2", 3, "3")));
        Assertions.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2", 3, "3", 4, "4")));
        Assertions.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2", 3, "3", 4, "4", 5, "5")));
        Assertions.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6")));
        Assertions.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6", 7, "7")));
        Assertions.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6", 7, "7", 8, "8")));
        Assertions.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6", 7, "7", 8, "8", 9, "9")));
        Assertions.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6", 7, "7", 8, "8", 9, "9", 10, "10")));
        Assertions.assertTrue((boolean)immutability.test(Map.ofEntries(new Map.Entry[0])));
        Assertions.assertTrue((boolean)immutability.test(Map.ofEntries(Map.entry(1, "1"))));
        Assertions.assertTrue((boolean)immutability.test(Map.ofEntries(Map.entry(1, "1"), Map.entry(2, "2"))));
        Assertions.assertTrue((boolean)immutability.test(new AbstractMap.SimpleImmutableEntry<Boolean, Boolean>(Boolean.TRUE, Boolean.TRUE)));
        AtomicInteger mutableObject = new AtomicInteger();
        Assertions.assertFalse((boolean)immutability.test(Collections.singletonList(mutableObject)));
        Assertions.assertFalse((boolean)immutability.test(Collections.singletonMap("1", mutableObject)));
        Assertions.assertFalse((boolean)immutability.test(new AbstractMap.SimpleImmutableEntry<String, AtomicInteger>("1", mutableObject)));
        Assertions.assertFalse((boolean)immutability.test(new AbstractMap.SimpleEntry<Boolean, Boolean>(Boolean.TRUE, Boolean.TRUE)));
    }

    @Immutable
    static class JCIPImmutableObject {
        JCIPImmutableObject() {
        }
    }
}

