/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.scheduler;

import java.util.function.Supplier;
import java.util.stream.Stream;

public interface Scheduler<I, M>
extends AutoCloseable {
    public void schedule(I var1, M var2);

    public void cancel(I var1);

    public Stream<I> stream();

    default public boolean contains(I id) {
        return this.stream().anyMatch(id::equals);
    }

    @Override
    public void close();

    public static <I, M> Scheduler<I, M> inactive() {
        return new InactiveScheduler();
    }

    public static <I, M> Scheduler<I, M> reference(Supplier<? extends Scheduler<I, M>> reference) {
        return new ReferenceScheduler(reference);
    }

    public static class InactiveScheduler<I, M>
    implements Scheduler<I, M> {
        protected InactiveScheduler() {
        }

        @Override
        public void schedule(I id, M metaData) {
        }

        @Override
        public void cancel(I id) {
        }

        @Override
        public boolean contains(I id) {
            return false;
        }

        @Override
        public Stream<I> stream() {
            return Stream.of(new Object[0]);
        }

        @Override
        public void close() {
        }
    }

    public static class ReferenceScheduler<I, M>
    implements Scheduler<I, M> {
        private final Supplier<? extends Scheduler<I, M>> reference;

        protected ReferenceScheduler(Supplier<? extends Scheduler<I, M>> reference) {
            this.reference = reference;
        }

        @Override
        public void schedule(I id, M metaData) {
            this.reference.get().schedule(id, metaData);
        }

        @Override
        public void cancel(I id) {
            this.reference.get().cancel(id);
        }

        @Override
        public boolean contains(I id) {
            return this.reference.get().contains(id);
        }

        @Override
        public Stream<I> stream() {
            return this.reference.get().stream();
        }

        @Override
        public void close() {
            this.reference.get().close();
        }
    }
}

