/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.cache.Cache;
import org.wildfly.clustering.server.cache.CacheStrategy;
import org.wildfly.clustering.server.manager.Service;

public class CacheTestCase {
    private static final int KEYS = 10;
    private static final int SIZE = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shared() throws InterruptedException, ExecutionException {
        Cache manager = CacheStrategy.CONCURRENT.createCache(Service::start, Service::stop);
        ArrayList keyFutures = new ArrayList(10);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            for (int i = 0; i < 10; ++i) {
                ArrayList<Future<ManagedService>> arrayList = new ArrayList<Future<ManagedService>>(100);
                keyFutures.add(arrayList);
                for (int j = 0; j < 100; ++j) {
                    int n = i;
                    Callable<ManagedService> task = () -> {
                        try (ManagedService object = (ManagedService)manager.computeIfAbsent((Object)key, ManagedService::new);){
                            ((AbstractBooleanAssert)Assertions.assertThat((boolean)object.isStarted()).as(object::toString)).isTrue();
                            ((AbstractBooleanAssert)Assertions.assertThat((boolean)object.isStopped()).as(object::toString)).isFalse();
                            Thread.sleep(10L);
                            ManagedService managedService = object;
                            return managedService;
                        }
                    };
                    arrayList.add(executor.submit(task));
                }
            }
            for (List list : keyFutures) {
                for (Future future : list) {
                    future.get();
                }
            }
            for (List list : keyFutures) {
                for (Future future : list) {
                    ManagedService object = (ManagedService)future.get();
                    ((AbstractBooleanAssert)Assertions.assertThat((boolean)object.isStarted()).as(object::toString)).isTrue();
                    ((AbstractBooleanAssert)Assertions.assertThat((boolean)object.isStopped()).as(object::toString)).isTrue();
                }
            }
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void unshared() {
        Cache context = CacheStrategy.NONE.createCache(Service::start, Service::stop);
        ManagedService object = (ManagedService)context.computeIfAbsent((Object)"foo", ManagedService::new);
        try {
            Assertions.assertThat((boolean)object.isStarted()).isTrue();
            Assertions.assertThat((boolean)object.isStopped()).isFalse();
            try (ManagedService object2 = (ManagedService)context.computeIfAbsent((Object)"foo", ManagedService::new);){
                Assertions.assertThat((Object)object2).isNotSameAs((Object)object);
                Assertions.assertThat((boolean)object2.isStarted()).isTrue();
                Assertions.assertThat((boolean)object2.isStopped()).isFalse();
            }
        }
        finally {
            Assertions.assertThat((boolean)object.isStarted()).isTrue();
            Assertions.assertThat((boolean)object.isStopped()).isFalse();
            object.close();
            Assertions.assertThat((boolean)object.isStarted()).isTrue();
            Assertions.assertThat((boolean)object.isStopped()).isTrue();
        }
    }

    static class ManagedService<I>
    implements Service,
    AutoCloseable {
        private volatile boolean started = false;
        private volatile boolean stopped = false;
        private final I id;
        private final Runnable closeTask;

        ManagedService(I id, Runnable closeTask) {
            this.id = id;
            this.closeTask = closeTask;
        }

        public I getId() {
            return this.id;
        }

        public boolean isStarted() {
            return this.started;
        }

        public void start() {
            this.started = true;
        }

        public void stop() {
            this.stopped = true;
        }

        boolean isStopped() {
            return this.stopped;
        }

        @Override
        public void close() {
            this.closeTask.run();
        }
    }
}

