/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.util;

import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.server.util.BlockingExecutor;

public class BlockingExecutorTestCase {
    @Test
    public void testExecuteRunnable() {
        Runnable closeTask = (Runnable)Mockito.mock(Runnable.class);
        BlockingExecutor executor = BlockingExecutor.newInstance((Runnable)closeTask);
        Runnable executeTask = (Runnable)Mockito.mock(Runnable.class);
        executor.execute(executeTask);
        ((Runnable)Mockito.verify((Object)executeTask)).run();
        ((Runnable)Mockito.verify((Object)closeTask, (VerificationMode)Mockito.never())).run();
        Mockito.reset((Object[])new Runnable[]{executeTask});
        executor.close();
        ((Runnable)Mockito.verify((Object)closeTask)).run();
        Mockito.reset((Object[])new Runnable[]{closeTask});
        executor.close();
        ((Runnable)Mockito.verify((Object)closeTask, (VerificationMode)Mockito.never())).run();
        executor.execute(executeTask);
        ((Runnable)Mockito.verify((Object)executeTask, (VerificationMode)Mockito.never())).run();
        ((Runnable)Mockito.verify((Object)closeTask, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void testExecuteSupplier() {
        Runnable closeTask = (Runnable)Mockito.mock(Runnable.class);
        BlockingExecutor executor = BlockingExecutor.newInstance((Runnable)closeTask);
        Object expected = new Object();
        Supplier executeTask = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when(executeTask.get()).thenReturn(expected);
        Optional result = executor.execute(executeTask);
        ((OptionalAssert)Assertions.assertThat((Optional)result).isPresent()).containsSame(expected);
        ((Runnable)Mockito.verify((Object)closeTask, (VerificationMode)Mockito.never())).run();
        Mockito.reset((Object[])new Supplier[]{executeTask});
        executor.close();
        ((Runnable)Mockito.verify((Object)closeTask)).run();
        Mockito.reset((Object[])new Runnable[]{closeTask});
        executor.close();
        ((Runnable)Mockito.verify((Object)closeTask, (VerificationMode)Mockito.never())).run();
        ((Runnable)Mockito.verify((Object)closeTask, (VerificationMode)Mockito.never())).run();
        result = executor.execute(executeTask);
        Assertions.assertThat((Optional)result).isEmpty();
        ((Runnable)Mockito.verify((Object)closeTask, (VerificationMode)Mockito.never())).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concurrent() throws InterruptedException, ExecutionException {
        Runnable closeTask = (Runnable)Mockito.mock(Runnable.class);
        BlockingExecutor executor = BlockingExecutor.newInstance((Runnable)closeTask);
        ExecutorService service = Executors.newFixedThreadPool(2);
        try {
            CountDownLatch executeLatch = new CountDownLatch(1);
            CountDownLatch stopLatch = new CountDownLatch(1);
            Runnable executeTask = () -> {
                try {
                    executeLatch.countDown();
                    stopLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            };
            Future<?> executeFuture = service.submit(() -> executor.execute(executeTask));
            executeLatch.await();
            Future<?> closeFuture = service.submit(() -> ((BlockingExecutor)executor).close());
            Thread.yield();
            ((Runnable)Mockito.verify((Object)closeTask, (VerificationMode)Mockito.never())).run();
            stopLatch.countDown();
            executeFuture.get();
            closeFuture.get();
            ((Runnable)Mockito.verify((Object)closeTask)).run();
        }
        finally {
            service.shutdownNow();
        }
    }
}

