/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.affinity;

import java.util.Map;
import java.util.function.Function;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.registry.Registry;

public class RegistryGroupMemberMapper<M extends GroupMember>
implements Function<M, String> {
    private final Registry<String, Void, M> registry;
    private final String localKey;

    RegistryGroupMemberMapper(Registry<String, Void, M> registry) {
        this.registry = registry;
        this.localKey = (String)registry.getEntry(registry.getGroup().getLocalMember()).getKey();
    }

    @Override
    public String apply(M member) {
        Map.Entry entry = this.registry.getEntry(member);
        return entry != null ? (String)entry.getKey() : this.localKey;
    }
}

