/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.coarse;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.session.cache.metadata.InvalidatableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.coarse.DefaultImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.coarse.SessionMetaDataEntry;

public class DefaultSessionMetaData
extends DefaultImmutableSessionMetaData
implements InvalidatableSessionMetaData {
    private final SessionMetaDataEntry entry;
    private final CacheEntryMutator mutator;
    private final AtomicBoolean valid = new AtomicBoolean(true);

    public DefaultSessionMetaData(SessionMetaDataEntry entry, CacheEntryMutator mutator) {
        super(entry);
        this.entry = entry;
        this.mutator = mutator;
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }

    @Override
    public boolean invalidate() {
        return this.valid.compareAndSet(true, false);
    }

    public void setLastAccess(Instant startTime, Instant endTime) {
        Instant normalizedStartTime = startTime.truncatedTo(ChronoUnit.MILLIS);
        Duration duration = Duration.between(startTime, endTime);
        long seconds = duration.getSeconds();
        if (duration.getNano() > 0) {
            ++seconds;
        }
        Instant normalizedEndTime = normalizedStartTime.plus(seconds > 1L ? Duration.ofSeconds(seconds) : ChronoUnit.SECONDS.getDuration());
        this.entry.getLastAccessStartTime().set((Object)normalizedStartTime);
        this.entry.getLastAccessEndTime().set((Object)normalizedEndTime);
    }

    public void setTimeout(Duration duration) {
        this.entry.setTimeout(duration.isNegative() ? Duration.ZERO : duration);
    }

    @Override
    public void close() {
        this.mutator.mutate();
    }
}

