/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.coarse;

import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.server.offset.Value;
import org.wildfly.clustering.session.cache.metadata.coarse.ImmutableSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.MutableSessionMetaDataOffsetValues;
import org.wildfly.clustering.session.cache.metadata.coarse.SessionMetaDataEntry;

public class MutableSessionMetaDataEntry
implements SessionMetaDataEntry {
    private final ImmutableSessionMetaDataEntry entry;
    private final Value<Duration> timeout;
    private final Value<Instant> lastAccessStartTime;
    private final Value<Instant> lastAccessEndTime;

    public MutableSessionMetaDataEntry(ImmutableSessionMetaDataEntry entry, MutableSessionMetaDataOffsetValues values) {
        this.entry = entry;
        this.timeout = values.getTimeout();
        this.lastAccessStartTime = values.getLastAccessStartTime();
        this.lastAccessEndTime = values.getLastAccessEndTime();
    }

    @Override
    public boolean isNew() {
        return this.entry.isNew();
    }

    @Override
    public Instant getCreationTime() {
        return this.entry.getCreationTime();
    }

    public Duration getTimeout() {
        return (Duration)this.timeout.get();
    }

    @Override
    public void setTimeout(Duration timeout) {
        this.timeout.set((Object)timeout);
    }

    @Override
    public Value<Instant> getLastAccessStartTime() {
        return this.lastAccessStartTime;
    }

    @Override
    public Value<Instant> getLastAccessEndTime() {
        return this.lastAccessEndTime;
    }
}

