/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.coarse;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.server.offset.Offset;
import org.wildfly.clustering.session.cache.metadata.coarse.ContextualSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.DefaultSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.SessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.SessionMetaDataEntryOffsets;

public abstract class AbstractSessionMetaDataEntryTestCase
implements Consumer<ContextualSessionMetaDataEntry<Object>> {
    private final Instant originalLastAccessEndTime = Instant.now();
    private final Instant originalLastAccessStartTime = this.originalLastAccessEndTime.minus(Duration.ofSeconds(1L));
    private final Instant created = this.originalLastAccessStartTime.minus(Duration.ofMinutes(1L));
    private final Duration originalTimeout = Duration.ofMinutes(20L);
    private final Duration lastAccessStartTimeDelta = Duration.ofSeconds(10L);
    private final Duration lastAccessEndTimeDelta = Duration.ofSeconds(2L);
    private final Duration timeoutDelta = Duration.ofMinutes(10L);
    private final Instant updatedLastAccessStartTime = this.originalLastAccessStartTime.plus(this.lastAccessStartTimeDelta);
    private final Instant updatedLastAccessEndTime = this.originalLastAccessEndTime.plus(this.lastAccessEndTimeDelta);
    private final Duration updatedTimeout = this.originalTimeout.plus(this.timeoutDelta);

    @Test
    public void test() {
        DefaultSessionMetaDataEntry entry = new DefaultSessionMetaDataEntry(this.created);
        Assertions.assertEquals((Object)this.created, (Object)entry.getCreationTime());
        Assertions.assertEquals((Object)this.created, (Object)entry.getLastAccessStartTime().get());
        Assertions.assertEquals((Object)this.created, (Object)entry.getLastAccessEndTime().get());
        Assertions.assertEquals((Object)Duration.ZERO, (Object)entry.getTimeout());
        Assertions.assertNull((Object)entry.getContext().get(() -> null));
        entry.getLastAccessStartTime().set((Object)this.originalLastAccessStartTime);
        entry.getLastAccessEndTime().set((Object)this.originalLastAccessEndTime);
        entry.setTimeout(this.originalTimeout);
        this.verifyOriginalState((SessionMetaDataEntry)entry);
        SessionMetaDataEntryOffsets offsets = (SessionMetaDataEntryOffsets)Mockito.mock(SessionMetaDataEntryOffsets.class);
        ((SessionMetaDataEntryOffsets)Mockito.doReturn((Object)Offset.forDuration((Duration)this.timeoutDelta)).when((Object)offsets)).getTimeoutOffset();
        ((SessionMetaDataEntryOffsets)Mockito.doReturn((Object)Offset.forInstant((Duration)this.lastAccessStartTimeDelta)).when((Object)offsets)).getLastAccessStartTimeOffset();
        ((SessionMetaDataEntryOffsets)Mockito.doReturn((Object)Offset.forInstant((Duration)this.lastAccessEndTimeDelta)).when((Object)offsets)).getLastAccessEndTimeOffset();
        ContextualSessionMetaDataEntry remapped = entry.remap(offsets);
        this.verifyUpdatedState((SessionMetaDataEntry)remapped);
        this.verifyOriginalState((SessionMetaDataEntry)entry);
        this.accept(entry);
    }

    void updateState(SessionMetaDataEntry entry) {
        entry.getLastAccessStartTime().set((Object)this.updatedLastAccessStartTime);
        entry.getLastAccessEndTime().set((Object)this.updatedLastAccessEndTime);
        entry.setTimeout(this.updatedTimeout);
    }

    void verifyOriginalState(SessionMetaDataEntry entry) {
        Assertions.assertEquals((Object)this.created, (Object)entry.getCreationTime());
        Assertions.assertEquals((Object)this.originalLastAccessStartTime, (Object)entry.getLastAccessStartTime().get());
        Assertions.assertEquals((Object)this.originalLastAccessEndTime, (Object)entry.getLastAccessEndTime().get());
        Assertions.assertEquals((Object)this.originalTimeout, (Object)entry.getTimeout());
    }

    void verifyUpdatedState(SessionMetaDataEntry entry) {
        Assertions.assertEquals((Object)this.created, (Object)entry.getCreationTime());
        Assertions.assertEquals((Object)this.updatedLastAccessStartTime, (Object)entry.getLastAccessStartTime().get());
        Assertions.assertEquals((Object)this.updatedLastAccessEndTime, (Object)entry.getLastAccessEndTime().get());
        Assertions.assertEquals((Object)this.updatedTimeout, (Object)entry.getTimeout());
    }
}

