/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionAccessMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.FineSessionMetaDataSerializationContextInitializer;

public class DefaultSessionAccessMetaDataEntryMarshallerTestCase {
    @Test
    public void test() throws IOException {
        MarshallingTester tester = new ProtoStreamTesterFactory(List.of(new FineSessionMetaDataSerializationContextInitializer())).createTester();
        DefaultSessionAccessMetaDataEntry metaData = new DefaultSessionAccessMetaDataEntry();
        metaData.setLastAccessDuration(Duration.ZERO, Duration.ofNanos(100000000L));
        tester.test((Object)metaData, DefaultSessionAccessMetaDataEntryMarshallerTestCase::assertEquals);
        metaData.setLastAccessDuration(Duration.ofSeconds(300L), Duration.ofNanos(100000000L));
        tester.test((Object)metaData, DefaultSessionAccessMetaDataEntryMarshallerTestCase::assertEquals);
        metaData.setLastAccessDuration(Duration.ofSeconds(300L), Duration.ofSeconds(1L, 100000000L));
        tester.test((Object)metaData, DefaultSessionAccessMetaDataEntryMarshallerTestCase::assertEquals);
    }

    static void assertEquals(DefaultSessionAccessMetaDataEntry metaData1, DefaultSessionAccessMetaDataEntry metaData2) {
        Assertions.assertEquals((Object)metaData1.getSinceCreationDuration(), (Object)metaData2.getSinceCreationDuration());
        Assertions.assertEquals((Object)metaData1.getLastAccessDuration(), (Object)metaData2.getLastAccessDuration());
    }
}

