/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.server.util.Supplied;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.cache.CompositeSessionFactory;
import org.wildfly.clustering.session.cache.Contextual;
import org.wildfly.clustering.session.cache.SessionFactory;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactory;
import org.wildfly.clustering.session.cache.metadata.InvalidatableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.SessionMetaDataFactory;
import org.wildfly.common.function.Functions;

public class CompositeSessionFactoryTestCase {
    private final SessionMetaDataFactory<Contextual<Object>> metaDataFactory = (SessionMetaDataFactory)Mockito.mock(SessionMetaDataFactory.class);
    private final SessionAttributesFactory<Object, Object> attributesFactory = (SessionAttributesFactory)Mockito.mock(SessionAttributesFactory.class);
    private final Object transientContext = new Object();
    private final SessionFactory<Object, Contextual<Object>, Object, Object> factory = new CompositeSessionFactory(this.metaDataFactory, this.attributesFactory, Functions.constantSupplier((Object)this.transientContext));

    @Test
    public void createValue() {
        Contextual contextual = (Contextual)Mockito.mock(Contextual.class);
        Object attributes = new Object();
        String id = "id";
        Mockito.when((Object)this.metaDataFactory.createValueAsync((Object)id, null)).thenReturn(CompletableFuture.completedStage(contextual));
        Mockito.when((Object)this.attributesFactory.createValueAsync((Object)id, null)).thenReturn(CompletableFuture.completedStage(attributes));
        Map.Entry result = (Map.Entry)this.factory.createValue((Object)id, null);
        Assertions.assertNotNull((Object)result);
        Assertions.assertSame((Object)contextual, result.getKey());
        Assertions.assertSame((Object)attributes, result.getValue());
    }

    @Test
    public void findValue() {
        String missingMetaDataSessionId = "no-meta-data";
        String missingAttributesSessionId = "no-attributes";
        String existingSessionId = "existing";
        Contextual contextual = (Contextual)Mockito.mock(Contextual.class);
        Object attributes = new Object();
        Mockito.when((Object)this.metaDataFactory.findValueAsync((Object)missingMetaDataSessionId)).thenReturn(CompletableFuture.completedStage(null));
        Mockito.when((Object)this.metaDataFactory.findValueAsync((Object)missingAttributesSessionId)).thenReturn(CompletableFuture.completedStage(contextual));
        Mockito.when((Object)this.metaDataFactory.findValueAsync((Object)existingSessionId)).thenReturn(CompletableFuture.completedStage(contextual));
        Mockito.when((Object)this.attributesFactory.findValueAsync((Object)missingMetaDataSessionId)).thenReturn(CompletableFuture.completedStage(attributes));
        Mockito.when((Object)this.attributesFactory.findValueAsync((Object)missingAttributesSessionId)).thenReturn(CompletableFuture.completedStage(null));
        Mockito.when((Object)this.attributesFactory.findValueAsync((Object)existingSessionId)).thenReturn(CompletableFuture.completedStage(attributes));
        Map.Entry missingMetaDataResult = (Map.Entry)this.factory.findValue((Object)missingMetaDataSessionId);
        Map.Entry missingAttributesResult = (Map.Entry)this.factory.findValue((Object)missingAttributesSessionId);
        Map.Entry existingSessionResult = (Map.Entry)this.factory.findValue((Object)existingSessionId);
        Assertions.assertNull((Object)missingMetaDataResult);
        Assertions.assertNull((Object)missingAttributesResult);
        Assertions.assertNotNull((Object)existingSessionResult);
        Assertions.assertSame((Object)contextual, existingSessionResult.getKey());
        Assertions.assertSame((Object)attributes, existingSessionResult.getValue());
    }

    @Test
    public void remove() {
        String id = "id";
        Mockito.when((Object)this.metaDataFactory.removeAsync((Object)id)).thenReturn(CompletableFuture.completedStage(null));
        Mockito.when((Object)this.attributesFactory.removeAsync((Object)id)).thenReturn(CompletableFuture.completedStage(null));
        this.factory.removeAsync(id);
        ((SessionMetaDataFactory)Mockito.verify(this.metaDataFactory)).removeAsync((Object)id);
        ((SessionAttributesFactory)Mockito.verify(this.attributesFactory)).removeAsync((Object)id);
    }

    @Test
    public void getMetaDataFactory() {
        Assertions.assertSame(this.metaDataFactory, (Object)this.factory.getMetaDataFactory());
    }

    @Test
    public void createSession() {
        Contextual contextual = (Contextual)Mockito.mock(Contextual.class);
        Object attributesValue = new Object();
        InvalidatableSessionMetaData metaData = (InvalidatableSessionMetaData)Mockito.mock(InvalidatableSessionMetaData.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Object context = new Object();
        String id = "id";
        Mockito.when((Object)this.metaDataFactory.createSessionMetaData(id, (Object)contextual)).thenReturn((Object)metaData);
        Mockito.when((Object)this.attributesFactory.createSessionAttributes((String)Mockito.same((Object)id), Mockito.same((Object)attributesValue), (ImmutableSessionMetaData)Mockito.same((Object)metaData), Mockito.same((Object)context))).thenReturn((Object)attributes);
        Mockito.when((Object)contextual.getContext()).thenReturn((Object)Supplied.simple());
        Session result = this.factory.createSession(id, Map.entry(contextual, attributesValue), context);
        Assertions.assertSame((Object)id, (Object)result.getId());
        Assertions.assertSame((Object)metaData, (Object)result.getMetaData());
        Assertions.assertSame((Object)attributes, (Object)result.getAttributes());
        Assertions.assertSame((Object)this.transientContext, (Object)result.getContext());
    }

    @Test
    public void createImmutableSession() {
        Contextual contextual = (Contextual)Mockito.mock(Contextual.class);
        Object attributesValue = new Object();
        ImmutableSessionMetaData metaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        Map attributes = (Map)Mockito.mock(Map.class);
        String id = "id";
        Mockito.when((Object)this.metaDataFactory.createImmutableSessionMetaData(id, (Object)contextual)).thenReturn((Object)metaData);
        Mockito.when((Object)this.attributesFactory.createImmutableSessionAttributes(id, attributesValue)).thenReturn((Object)attributes);
        ImmutableSession result = this.factory.createImmutableSession(id, Map.entry(contextual, attributesValue));
        Assertions.assertSame((Object)id, (Object)result.getId());
        Assertions.assertSame((Object)metaData, (Object)result.getMetaData());
        Assertions.assertSame((Object)attributes, (Object)result.getAttributes());
    }

    @Test
    public void close() {
        this.factory.close();
        ((SessionMetaDataFactory)Mockito.verify(this.metaDataFactory)).close();
        ((SessionAttributesFactory)Mockito.verify(this.attributesFactory)).close();
    }
}

