/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.user;

import java.util.Map;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.Batcher;
import org.wildfly.clustering.server.manager.IdentifierFactory;
import org.wildfly.clustering.session.cache.user.UserFactory;
import org.wildfly.clustering.session.user.User;
import org.wildfly.clustering.session.user.UserManager;

public class DefaultUserManager<CV, C, T, SV, D, S, B extends Batch>
implements UserManager<C, T, D, S, B> {
    private final UserFactory<CV, C, T, SV, D, S> factory;
    private final Batcher<B> batcher;
    private final IdentifierFactory<String> identifierFactory;

    public DefaultUserManager(UserFactory<CV, C, T, SV, D, S> factory, IdentifierFactory<String> identifierFactory, Batcher<B> batcher) {
        this.factory = factory;
        this.batcher = batcher;
        this.identifierFactory = identifierFactory;
    }

    public User<C, T, D, S> createUser(String id, C context) {
        Map.Entry value = (Map.Entry)this.factory.createValue(id, context);
        return this.factory.createUser(id, value);
    }

    public User<C, T, D, S> findUser(String id) {
        Map.Entry value = (Map.Entry)this.factory.findValue(id);
        return value != null ? this.factory.createUser(id, value) : null;
    }

    public Batcher<B> getBatcher() {
        return this.batcher;
    }

    public Supplier<String> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public void start() {
        this.identifierFactory.start();
    }

    public void stop() {
        this.identifierFactory.stop();
    }
}

