/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.attributes.coarse;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionAttributes;
import org.wildfly.clustering.session.cache.attributes.coarse.ImmutableSessionActivationNotifier;
import org.wildfly.clustering.session.cache.attributes.coarse.SessionActivationNotifier;
import org.wildfly.clustering.session.container.SessionActivationListenerFacadeProvider;

public class ImmutableSessionActivationNotifierTestCase {
    private final SessionActivationListenerFacadeProvider<Session, Context, Listener> provider = (SessionActivationListenerFacadeProvider)Mockito.mock(SessionActivationListenerFacadeProvider.class);
    private final ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
    private final Context context = (Context)Mockito.mock(Context.class);
    private final Listener listener1 = (Listener)Mockito.mock(Listener.class);
    private final Listener listener2 = (Listener)Mockito.mock(Listener.class);
    private final SessionActivationNotifier notifier = new ImmutableSessionActivationNotifier(this.provider, this.session, (Object)this.context);

    @AfterEach
    public void destroy() {
        Mockito.reset((Object[])new Object[]{this.session, this.provider});
    }

    @Test
    public void test() {
        ImmutableSessionAttributes attributes = (ImmutableSessionAttributes)Mockito.mock(ImmutableSessionAttributes.class);
        Mockito.when((Object)this.session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.getAttributeNames()).thenReturn(Set.of("foo", "bar", "listener1", "listener2"));
        Mockito.when((Object)attributes.getAttribute("foo")).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)attributes.getAttribute("bar")).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)attributes.getAttribute("listener1")).thenReturn((Object)this.listener1);
        Mockito.when((Object)attributes.getAttribute("listener2")).thenReturn((Object)this.listener2);
        Mockito.when((Object)this.provider.asSessionActivationListener(Mockito.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.provider.asSessionActivationListener((Object)this.listener1)).thenReturn(Optional.of(this.listener1));
        Mockito.when((Object)this.provider.asSessionActivationListener((Object)this.listener2)).thenReturn(Optional.of(this.listener2));
        Session session = (Session)Mockito.mock(Session.class);
        Consumer prePassivateNotifier1 = (Consumer)Mockito.mock(Consumer.class);
        Consumer prePassivateNotifier2 = (Consumer)Mockito.mock(Consumer.class);
        Consumer postActivateNotifier1 = (Consumer)Mockito.mock(Consumer.class);
        Consumer postActivateNotifier2 = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)((Session)this.provider.asSession((ImmutableSession)Mockito.same((Object)this.session), (Object)((Context)Mockito.same((Object)this.context))))).thenReturn((Object)session);
        Mockito.when((Object)this.provider.prePassivateNotifier((Object)((Listener)Mockito.same((Object)this.listener1)))).thenReturn((Object)prePassivateNotifier1);
        Mockito.when((Object)this.provider.prePassivateNotifier((Object)((Listener)Mockito.same((Object)this.listener2)))).thenReturn((Object)prePassivateNotifier2);
        Mockito.when((Object)this.provider.postActivateNotifier((Object)((Listener)Mockito.same((Object)this.listener1)))).thenReturn((Object)postActivateNotifier1);
        Mockito.when((Object)this.provider.postActivateNotifier((Object)((Listener)Mockito.same((Object)this.listener2)))).thenReturn((Object)postActivateNotifier2);
        this.notifier.prePassivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        this.notifier.postActivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1)).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2)).accept(session);
        Mockito.reset((Object[])new Consumer[]{postActivateNotifier1, postActivateNotifier2});
        this.notifier.postActivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        this.notifier.prePassivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1)).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2)).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        Mockito.reset((Object[])new Consumer[]{prePassivateNotifier1, prePassivateNotifier2});
        this.notifier.prePassivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        this.notifier.postActivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1)).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2)).accept(session);
    }

    @Test
    public void postActivate() {
        ImmutableSessionAttributes attributes = (ImmutableSessionAttributes)Mockito.mock(ImmutableSessionAttributes.class);
        UUID foo = UUID.randomUUID();
        UUID bar = UUID.randomUUID();
        Mockito.when((Object)this.session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.getAttributeNames()).thenReturn(Set.of("foo", "bar", "listener1", "listener2"));
        Mockito.when((Object)attributes.getAttribute("foo")).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)attributes.getAttribute("bar")).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)attributes.getAttribute("listener1")).thenReturn((Object)this.listener1);
        Mockito.when((Object)attributes.getAttribute("listener2")).thenReturn((Object)this.listener2);
        Mockito.when((Object)this.provider.asSessionActivationListener((Object)foo)).thenReturn(Optional.empty());
        Mockito.when((Object)this.provider.asSessionActivationListener((Object)bar)).thenReturn(Optional.empty());
        Mockito.when((Object)this.provider.asSessionActivationListener((Object)this.listener1)).thenReturn(Optional.of(this.listener1));
        Mockito.when((Object)this.provider.asSessionActivationListener((Object)this.listener2)).thenReturn(Optional.of(this.listener2));
        Session session = (Session)Mockito.mock(Session.class);
        Consumer notifier1 = (Consumer)Mockito.mock(Consumer.class);
        Consumer notifier2 = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)((Session)this.provider.asSession((ImmutableSession)Mockito.same((Object)this.session), (Object)((Context)Mockito.same((Object)this.context))))).thenReturn((Object)session);
        Mockito.when((Object)this.provider.postActivateNotifier((Object)((Listener)Mockito.same((Object)this.listener1)))).thenReturn((Object)notifier1);
        Mockito.when((Object)this.provider.postActivateNotifier((Object)((Listener)Mockito.same((Object)this.listener2)))).thenReturn((Object)notifier2);
        this.notifier.postActivate();
        ((SessionActivationListenerFacadeProvider)Mockito.verify(this.provider, (VerificationMode)Mockito.never())).prePassivateNotifier((Object)this.listener1);
        ((SessionActivationListenerFacadeProvider)Mockito.verify(this.provider, (VerificationMode)Mockito.never())).prePassivateNotifier((Object)this.listener2);
        ((Consumer)Mockito.verify((Object)notifier1)).accept(session);
        ((Consumer)Mockito.verify((Object)notifier2)).accept(session);
    }

    static interface Context {
    }

    static interface Listener {
    }

    static interface Session {
    }
}

