/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.offset.Offset;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionCreationMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaDataEntry;

public abstract class AbstractSessionCreationMetaDataEntryTestCase
implements Consumer<SessionCreationMetaDataEntry<Object>> {
    private final Instant created = Instant.now();
    private final Duration originalTimeout = Duration.ofMinutes(20L);
    private final Duration timeoutDelta = Duration.ofMinutes(10L);
    private final Duration updatedTimeout = this.originalTimeout.plus(this.timeoutDelta);

    @Test
    public void test() {
        DefaultSessionCreationMetaDataEntry entry = new DefaultSessionCreationMetaDataEntry(this.created);
        Assertions.assertEquals((Object)this.created, (Object)entry.getCreationTime());
        Assertions.assertEquals((Object)Duration.ZERO, (Object)entry.getTimeout());
        Assertions.assertNull((Object)entry.getContext().get(() -> null));
        entry.setTimeout(this.originalTimeout);
        this.verifyOriginalState((SessionCreationMetaData)entry);
        SessionCreationMetaDataEntry remapped = entry.remap(() -> Offset.forDuration((Duration)this.timeoutDelta));
        this.verifyUpdatedState((SessionCreationMetaData)remapped);
        this.verifyOriginalState((SessionCreationMetaData)entry);
        this.accept(entry);
    }

    void updateState(SessionCreationMetaData metaData) {
        metaData.setTimeout(this.updatedTimeout);
    }

    void verifyOriginalState(SessionCreationMetaData metaData) {
        Assertions.assertEquals((Object)this.created, (Object)metaData.getCreationTime());
        Assertions.assertEquals((Object)this.originalTimeout, (Object)metaData.getTimeout());
    }

    void verifyUpdatedState(SessionCreationMetaData metaData) {
        Assertions.assertEquals((Object)this.created, (Object)metaData.getCreationTime());
        Assertions.assertEquals((Object)this.updatedTimeout, (Object)metaData.getTimeout());
    }
}

