/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.user;

import java.util.Map;
import org.wildfly.clustering.cache.Remover;
import org.wildfly.clustering.session.user.User;
import org.wildfly.clustering.session.user.UserSessions;

public class CompositeUser<C, T, D, S>
implements User<C, T, D, S> {
    private final String id;
    private final Map.Entry<C, T> contextEntry;
    private final UserSessions<D, S> sessions;
    private final Remover<String> remover;

    public CompositeUser(String id, Map.Entry<C, T> contextEntry, UserSessions<D, S> sessions, Remover<String> remover) {
        this.id = id;
        this.contextEntry = contextEntry;
        this.sessions = sessions;
        this.remover = remover;
    }

    public String getId() {
        return this.id;
    }

    public C getPersistentContext() {
        return this.contextEntry.getKey();
    }

    public UserSessions<D, S> getSessions() {
        return this.sessions;
    }

    public void invalidate() {
        this.remover.remove((Object)this.id);
    }

    public T getTransientContext() {
        return this.contextEntry.getValue();
    }
}

