/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.function.Consumer;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionAttributes;
import org.wildfly.clustering.session.SessionMetaData;

public class ValidSession<C>
implements Session<C> {
    private final Session<C> session;
    private final Consumer<ImmutableSession> closeTask;

    public ValidSession(Session<C> session, Consumer<ImmutableSession> closeTask) {
        this.session = session;
        this.closeTask = closeTask;
    }

    private void validate() {
        if (!this.session.isValid()) {
            throw new IllegalStateException(this.session.getId());
        }
    }

    public String getId() {
        return this.session.getId();
    }

    public boolean isValid() {
        return this.session.isValid();
    }

    public C getContext() {
        return (C)this.session.getContext();
    }

    public SessionMetaData getMetaData() {
        this.validate();
        return this.session.getMetaData();
    }

    public SessionAttributes getAttributes() {
        this.validate();
        return this.session.getAttributes();
    }

    public void invalidate() {
        this.validate();
        this.session.invalidate();
    }

    public void close() {
        try {
            this.session.close();
        }
        finally {
            this.closeTask.accept((ImmutableSession)this.session);
        }
    }
}

