/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionCreationMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.FineSessionMetaDataSerializationContextInitializer;

public class DefaultSessionCreationMetaDataEntryMarshallerTestCase {
    @Test
    public void test() throws IOException {
        MarshallingTester tester = new ProtoStreamTesterFactory(List.of(new FineSessionMetaDataSerializationContextInitializer())).createTester();
        DefaultSessionCreationMetaDataEntry entry = new DefaultSessionCreationMetaDataEntry(Instant.now());
        entry.setTimeout(Duration.ofMinutes(30L));
        tester.test((Object)entry, DefaultSessionCreationMetaDataEntryMarshallerTestCase::assertEquals);
        entry.setTimeout(Duration.ofMinutes(10L));
        tester.test((Object)entry, DefaultSessionCreationMetaDataEntryMarshallerTestCase::assertEquals);
    }

    static void assertEquals(DefaultSessionCreationMetaDataEntry<Object> entry1, DefaultSessionCreationMetaDataEntry<Object> entry2) {
        Assertions.assertEquals((long)entry1.getCreationTime().toEpochMilli(), (long)entry2.getCreationTime().toEpochMilli());
        Assertions.assertEquals((Object)entry1.getTimeout(), (Object)entry2.getTimeout());
    }
}

