/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.Map;
import java.util.function.Consumer;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.cache.PassivationListener;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;

public class MockSessionSpecificationProvider<C>
implements SessionSpecificationProvider<Map.Entry<ImmutableSession, C>, C, PassivationListener<C>> {
    public Consumer<Map.Entry<ImmutableSession, C>> prePassivate(PassivationListener<C> listener) {
        return listener::passivated;
    }

    public Consumer<Map.Entry<ImmutableSession, C>> postActivate(PassivationListener<C> listener) {
        return listener::activated;
    }

    public Class<PassivationListener<C>> getSessionActivationListenerClass() {
        return PassivationListener.class;
    }

    public PassivationListener<C> asSessionActivationListener(final Consumer<Map.Entry<ImmutableSession, C>> prePassivate, final Consumer<Map.Entry<ImmutableSession, C>> postActivate) {
        return new PassivationListener<C>(){

            @Override
            public void passivated(Map.Entry<ImmutableSession, C> entry) {
                prePassivate.accept(entry);
            }

            @Override
            public void activated(Map.Entry<ImmutableSession, C> entry) {
                postActivate.accept(entry);
            }
        };
    }

    public Map.Entry<ImmutableSession, C> asSession(ImmutableSession session, C context) {
        return Map.entry(session, context);
    }
}

