/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionAttributes;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.session.cache.AbstractImmutableSession;

public class DetachedSession<C, B extends Batch>
extends AbstractImmutableSession
implements Session<C>,
SessionMetaData,
SessionAttributes {
    private final SessionManager<C, B> manager;
    private final C context;

    public DetachedSession(SessionManager<C, B> manager, String id, C context) {
        super(id);
        this.manager = manager;
        this.context = context;
    }

    public SessionMetaData getMetaData() {
        return this;
    }

    public SessionAttributes getAttributes() {
        return this;
    }

    public C getContext() {
        return this.context;
    }

    public void close() {
    }

    public boolean isNew() {
        return false;
    }

    public boolean isValid() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            boolean bl = this.manager.findImmutableSession(this.getId()) != null;
            return bl;
        }
    }

    public void invalidate() {
        try (Batch batch = this.manager.getBatcher().createBatch();
             Session<C> session = this.getSession();){
            session.invalidate();
        }
    }

    public boolean isExpired() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            boolean bl;
            block12: {
                Session<C> session = this.getSession();
                try {
                    bl = session.getMetaData().isExpired();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return bl;
        }
    }

    public Instant getCreationTime() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Instant instant;
            block12: {
                Session<C> session = this.getSession();
                try {
                    instant = session.getMetaData().getCreationTime();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return instant;
        }
    }

    public Instant getLastAccessStartTime() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Instant instant;
            block12: {
                Session<C> session = this.getSession();
                try {
                    instant = session.getMetaData().getLastAccessStartTime();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return instant;
        }
    }

    public Instant getLastAccessEndTime() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Instant instant;
            block12: {
                Session<C> session = this.getSession();
                try {
                    instant = session.getMetaData().getLastAccessEndTime();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return instant;
        }
    }

    public Duration getTimeout() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Duration duration;
            block12: {
                Session<C> session = this.getSession();
                try {
                    duration = session.getMetaData().getTimeout();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return duration;
        }
    }

    public void setLastAccess(Instant startTime, Instant endTime) {
        throw new IllegalStateException();
    }

    public void setTimeout(Duration duration) {
        try (Batch batch = this.manager.getBatcher().createBatch();
             Session<C> session = this.getSession();){
            session.getMetaData().setTimeout(duration);
        }
    }

    public Set<String> getAttributeNames() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Set set;
            block12: {
                Session<C> session = this.getSession();
                try {
                    set = session.getAttributes().getAttributeNames();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return set;
        }
    }

    public Object getAttribute(String name) {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Object object;
            block12: {
                Session<C> session = this.getSession();
                try {
                    object = session.getAttributes().getAttribute(name);
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return object;
        }
    }

    public Object removeAttribute(String name) {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Object object;
            block12: {
                Session<C> session = this.getSession();
                try {
                    object = session.getAttributes().removeAttribute(name);
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return object;
        }
    }

    public Object setAttribute(String name, Object value) {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Object object;
            block12: {
                Session<C> session = this.getSession();
                try {
                    object = session.getAttributes().setAttribute(name, value);
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return object;
        }
    }

    private Session<C> getSession() {
        return Optional.ofNullable(this.manager.findSession(this.getId())).orElseThrow(IllegalStateException::new);
    }
}

