/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.attributes.coarse;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionAttributes;
import org.wildfly.clustering.session.cache.attributes.coarse.SessionActivationNotifier;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;

public class ImmutableSessionActivationNotifier<S, C, L>
implements SessionActivationNotifier {
    private final SessionSpecificationProvider<S, C, L> provider;
    private final ImmutableSession session;
    private final C context;
    private final AtomicBoolean active = new AtomicBoolean(false);
    private final Function<L, Consumer<S>> prePassivateFactory;
    private final Function<L, Consumer<S>> postActivateFactory;

    public ImmutableSessionActivationNotifier(SessionSpecificationProvider<S, C, L> provider, ImmutableSession session, C context) {
        this.provider = provider;
        this.session = session;
        this.context = context;
        this.prePassivateFactory = arg_0 -> this.provider.prePassivate(arg_0);
        this.postActivateFactory = arg_0 -> this.provider.postActivate(arg_0);
    }

    @Override
    public void prePassivate() {
        if (this.active.compareAndSet(true, false)) {
            this.notify(this.prePassivateFactory);
        }
    }

    @Override
    public void postActivate() {
        if (this.active.compareAndSet(false, true)) {
            this.notify(this.postActivateFactory);
        }
    }

    private void notify(Function<L, Consumer<S>> factory) {
        ImmutableSessionAttributes attributes = this.session.getAttributes();
        Set attributeNames = attributes.getAttributeNames();
        if (!attributeNames.isEmpty()) {
            ArrayList listeners = new ArrayList(attributeNames.size());
            for (String attributeName : attributeNames) {
                Object attributeValue = attributes.getAttribute(attributeName);
                if (attributeValue == null) continue;
                this.provider.asSessionActivationListener(attributeValue).ifPresent(listeners::add);
            }
            if (!listeners.isEmpty()) {
                Object session = this.provider.asSession(this.session, this.context);
                for (Object listener : listeners) {
                    factory.apply(listener).accept(session);
                }
            }
        }
    }
}

