/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.attributes.fine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.cache.attributes.fine.SessionAttributeActivationNotifier;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;

public class ImmutableSessionAttributeActivationNotifier<S, C, L>
implements SessionAttributeActivationNotifier {
    private final Function<Supplier<L>, L> prePassivateListenerFactory;
    private final Function<Supplier<L>, L> postActivateListenerFactory;
    private final SessionSpecificationProvider<S, C, L> provider;
    private final Function<L, Consumer<S>> prePassivateNotifier;
    private final Function<L, Consumer<S>> postActivateNotifier;
    private final S session;
    private final Map<Supplier<L>, L> listeners = new ConcurrentHashMap<Supplier<L>, L>();

    public ImmutableSessionAttributeActivationNotifier(SessionSpecificationProvider<S, C, L> provider, ImmutableSession session, C context) {
        this.provider = provider;
        this.prePassivateNotifier = arg_0 -> this.provider.prePassivate(arg_0);
        this.postActivateNotifier = arg_0 -> this.provider.postActivate(arg_0);
        this.prePassivateListenerFactory = new SessionActivationListenerFactory<S, C, L>(provider, true);
        this.postActivateListenerFactory = new SessionActivationListenerFactory<S, C, L>(provider, false);
        this.session = provider.asSession(session, context);
    }

    @Override
    public void prePassivate(Object object) {
        this.notify(object, this.prePassivateListenerFactory, this.prePassivateNotifier);
    }

    @Override
    public void postActivate(Object object) {
        this.notify(object, this.postActivateListenerFactory, this.postActivateNotifier);
    }

    private void notify(Object object, final Function<Supplier<L>, L> listenerFactory, final Function<L, Consumer<S>> notifierFactory) {
        this.provider.asSessionActivationListener(object).ifPresent(new Consumer<L>(){

            @Override
            public void accept(L listener) {
                SessionActivationListenerKey reference = new SessionActivationListenerKey(listener);
                ImmutableSessionAttributeActivationNotifier.this.listeners.computeIfAbsent(reference, listenerFactory);
                ((Consumer)notifierFactory.apply(listener)).accept(ImmutableSessionAttributeActivationNotifier.this.session);
            }
        });
    }

    @Override
    public void close() {
        for (L listener : this.listeners.values()) {
            this.provider.prePassivate(listener).accept(this.session);
        }
        this.listeners.clear();
    }

    private static class SessionActivationListenerFactory<S, C, L>
    implements Function<Supplier<L>, L> {
        private final SessionSpecificationProvider<S, C, L> provider;
        private final boolean active;

        SessionActivationListenerFactory(SessionSpecificationProvider<S, C, L> provider, boolean active) {
            this.provider = provider;
            this.active = active;
        }

        @Override
        public L apply(Supplier<L> reference) {
            final SessionSpecificationProvider<S, C, L> provider = this.provider;
            final L listener = reference.get();
            final AtomicBoolean active = new AtomicBoolean(this.active);
            Consumer prePassivate = new Consumer<S>(){

                @Override
                public void accept(S session) {
                    if (active.compareAndSet(true, false)) {
                        provider.prePassivate(listener).accept(session);
                    }
                }
            };
            Consumer postActivate = new Consumer<S>(){

                @Override
                public void accept(S session) {
                    if (active.compareAndSet(false, true)) {
                        provider.postActivate(listener).accept(session);
                    }
                }
            };
            return (L)provider.asSessionActivationListener(prePassivate, postActivate);
        }
    }

    private static class SessionActivationListenerKey<L>
    implements Supplier<L> {
        private final L listener;

        SessionActivationListenerKey(L listener) {
            this.listener = listener;
        }

        @Override
        public L get() {
            return this.listener;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof SessionActivationListenerKey)) {
                return false;
            }
            SessionActivationListenerKey reference = (SessionActivationListenerKey)object;
            return this.listener == reference.listener;
        }
    }
}

