/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.attributes.coarse;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.cache.attributes.coarse.ImmutableSessionActivationNotifier;
import org.wildfly.clustering.session.cache.attributes.coarse.SessionActivationNotifier;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;

public class ImmutableSessionActivationNotifierTestCase {
    private final SessionSpecificationProvider<Session, Context> sessionProvider = (SessionSpecificationProvider)Mockito.mock(SessionSpecificationProvider.class);
    private final SessionEventListenerSpecificationProvider<Session, Listener> listenerProvider = (SessionEventListenerSpecificationProvider)Mockito.mock(SessionEventListenerSpecificationProvider.class);
    private final ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
    private final Context context = (Context)Mockito.mock(Context.class);
    private final Listener listener1 = (Listener)Mockito.mock(Listener.class);
    private final Listener listener2 = (Listener)Mockito.mock(Listener.class);
    private final SessionActivationNotifier notifier = new ImmutableSessionActivationNotifier(this.sessionProvider, this.listenerProvider, this.session, (Object)this.context);

    @AfterEach
    public void destroy() {
        Mockito.reset((Object[])new Object[]{this.session, this.sessionProvider, this.listenerProvider});
    }

    @Test
    public void test() {
        Map attributes = Map.ofEntries(Map.entry("foo", UUID.randomUUID()), Map.entry("bar", UUID.randomUUID()), Map.entry("listener1", this.listener1), Map.entry("listener2", this.listener2));
        ((ImmutableSession)Mockito.doReturn(attributes).when((Object)this.session)).getAttributes();
        ((SessionEventListenerSpecificationProvider)Mockito.doReturn(Optional.empty()).when(this.listenerProvider)).asEventListener(Mockito.any(UUID.class));
        ((SessionEventListenerSpecificationProvider)Mockito.doReturn(Optional.of(this.listener1)).when(this.listenerProvider)).asEventListener((Object)this.listener1);
        ((SessionEventListenerSpecificationProvider)Mockito.doReturn(Optional.of(this.listener2)).when(this.listenerProvider)).asEventListener((Object)this.listener2);
        Session session = (Session)Mockito.mock(Session.class);
        Consumer prePassivateNotifier1 = (Consumer)Mockito.mock(Consumer.class);
        Consumer prePassivateNotifier2 = (Consumer)Mockito.mock(Consumer.class);
        Consumer postActivateNotifier1 = (Consumer)Mockito.mock(Consumer.class);
        Consumer postActivateNotifier2 = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)((Session)this.sessionProvider.asSession((ImmutableSession)Mockito.same((Object)this.session), (Object)((Context)Mockito.same((Object)this.context))))).thenReturn((Object)session);
        Mockito.when((Object)this.listenerProvider.preEvent((Object)((Listener)Mockito.same((Object)this.listener1)))).thenReturn((Object)prePassivateNotifier1);
        Mockito.when((Object)this.listenerProvider.preEvent((Object)((Listener)Mockito.same((Object)this.listener2)))).thenReturn((Object)prePassivateNotifier2);
        Mockito.when((Object)this.listenerProvider.postEvent((Object)((Listener)Mockito.same((Object)this.listener1)))).thenReturn((Object)postActivateNotifier1);
        Mockito.when((Object)this.listenerProvider.postEvent((Object)((Listener)Mockito.same((Object)this.listener2)))).thenReturn((Object)postActivateNotifier2);
        this.notifier.prePassivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        this.notifier.postActivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1)).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2)).accept(session);
        Mockito.reset((Object[])new Consumer[]{postActivateNotifier1, postActivateNotifier2});
        this.notifier.postActivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        this.notifier.prePassivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1)).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2)).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        Mockito.reset((Object[])new Consumer[]{prePassivateNotifier1, prePassivateNotifier2});
        this.notifier.prePassivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        this.notifier.postActivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1)).accept(session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2)).accept(session);
    }

    @Test
    public void postActivate() {
        Map attributes = Map.ofEntries(Map.entry("foo", UUID.randomUUID()), Map.entry("bar", UUID.randomUUID()), Map.entry("listener1", this.listener1), Map.entry("listener2", this.listener2));
        ((ImmutableSession)Mockito.doReturn(attributes).when((Object)this.session)).getAttributes();
        ((SessionEventListenerSpecificationProvider)Mockito.doReturn(Optional.empty()).when(this.listenerProvider)).asEventListener(Mockito.any(UUID.class));
        ((SessionEventListenerSpecificationProvider)Mockito.doReturn(Optional.of(this.listener1)).when(this.listenerProvider)).asEventListener((Object)this.listener1);
        ((SessionEventListenerSpecificationProvider)Mockito.doReturn(Optional.of(this.listener2)).when(this.listenerProvider)).asEventListener((Object)this.listener2);
        Session session = (Session)Mockito.mock(Session.class);
        Consumer notifier1 = (Consumer)Mockito.mock(Consumer.class);
        Consumer notifier2 = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)((Session)this.sessionProvider.asSession((ImmutableSession)Mockito.same((Object)this.session), (Object)((Context)Mockito.same((Object)this.context))))).thenReturn((Object)session);
        Mockito.when((Object)this.listenerProvider.postEvent((Object)((Listener)Mockito.same((Object)this.listener1)))).thenReturn((Object)notifier1);
        Mockito.when((Object)this.listenerProvider.postEvent((Object)((Listener)Mockito.same((Object)this.listener2)))).thenReturn((Object)notifier2);
        this.notifier.postActivate();
        ((SessionEventListenerSpecificationProvider)Mockito.verify(this.listenerProvider, (VerificationMode)Mockito.never())).preEvent((Object)this.listener1);
        ((SessionEventListenerSpecificationProvider)Mockito.verify(this.listenerProvider, (VerificationMode)Mockito.never())).preEvent((Object)this.listener2);
        ((Consumer)Mockito.verify((Object)notifier1)).accept(session);
        ((Consumer)Mockito.verify((Object)notifier2)).accept(session);
    }

    static interface Context {
    }

    static interface Listener {
    }

    static interface Session {
    }
}

