/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ScalarMarshaller;
import org.wildfly.clustering.session.IdentifierMarshallerProvider;

public enum IdentifierMarshaller implements ScalarMarshaller<String>
{
    INSTANCE;

    private final Marshaller<String, ByteBuffer> marshaller = ServiceLoader.load(IdentifierMarshallerProvider.class, IdentifierMarshallerProvider.class.getClassLoader()).findFirst().map(IdentifierMarshallerProvider::getMarshaller).orElseThrow(IllegalStateException::new);

    public String readFrom(ProtoStreamReader reader) throws IOException {
        return (String)this.marshaller.read((Object)reader.readByteBuffer());
    }

    public void writeTo(ProtoStreamWriter writer, String id) throws IOException {
        ByteBuffer buffer = (ByteBuffer)this.marshaller.write((Object)id);
        int offset = buffer.arrayOffset();
        int length = buffer.limit() - offset;
        writer.writeVarint32(length);
        writer.writeRawBytes(buffer.array(), offset, length);
    }

    public Class<? extends String> getJavaClass() {
        return String.class;
    }

    public WireType getWireType() {
        return WireType.LENGTH_DELIMITED;
    }

    public static <K extends Key<String>> ProtoStreamMarshaller<K> getKeyMarshaller(Function<String, K> factory) {
        return INSTANCE.toMarshaller(((Key)factory.apply("")).getClass(), Key::getId, factory);
    }
}

