/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.wildfly.clustering.cache.BiCreator;
import org.wildfly.clustering.cache.Remover;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.cache.ImmutableSessionFactory;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactory;
import org.wildfly.clustering.session.cache.metadata.SessionMetaDataFactory;

public interface SessionFactory<C, MV, AV, SC>
extends ImmutableSessionFactory<MV, AV>,
BiCreator<String, MV, AV, Duration>,
Remover<String>,
Registration {
    @Override
    public SessionMetaDataFactory<MV> getMetaDataFactory();

    public SessionAttributesFactory<C, AV> getAttributesFactory();

    default public Map.Entry<CompletionStage<MV>, CompletionStage<AV>> createEntry(String id, Duration context) {
        return Map.entry(this.getMetaDataFactory().createValueAsync(id, context), this.getAttributesFactory().createValueAsync(id, null));
    }

    default public CompletionStage<Void> removeAsync(String id) {
        return CompletableFuture.allOf(this.getMetaDataFactory().removeAsync(id).toCompletableFuture(), this.getAttributesFactory().removeAsync(id).toCompletableFuture());
    }

    default public CompletionStage<Void> purgeAsync(String id) {
        return CompletableFuture.allOf(this.getMetaDataFactory().purgeAsync(id).toCompletableFuture(), this.getAttributesFactory().purgeAsync(id).toCompletableFuture());
    }

    public Session<SC> createSession(String var1, Map.Entry<MV, AV> var2, C var3);

    default public void close() {
        this.getMetaDataFactory().close();
        this.getAttributesFactory().close();
    }
}

