/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.user;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.session.cache.user.MutableUserSessions;
import org.wildfly.clustering.session.user.UserSessions;

public class MutableUserSessionsTestCase {
    private CacheEntryMutator mutator = (CacheEntryMutator)Mockito.mock(CacheEntryMutator.class);
    private Map<String, String> map = (Map)Mockito.mock(Map.class);
    private UserSessions<String, String> sessions = new MutableUserSessions(this.map, this.mutator);

    @Test
    public void getApplications() {
        Set<String> expected = Collections.singleton("deployment");
        Mockito.when(this.map.keySet()).thenReturn(expected);
        Set result = this.sessions.getDeployments();
        Assertions.assertEquals(expected, (Object)result);
        ((CacheEntryMutator)Mockito.verify((Object)this.mutator, (VerificationMode)Mockito.never())).mutate();
    }

    @Test
    public void getSession() {
        String expected = "id";
        String deployment = "deployment1";
        String missingDeployment = "deployment2";
        Mockito.when((Object)this.map.get(deployment)).thenReturn((Object)expected);
        Mockito.when((Object)this.map.get(missingDeployment)).thenReturn(null);
        Assertions.assertSame((Object)expected, (Object)this.sessions.getSession((Object)deployment));
        Assertions.assertNull((Object)this.sessions.getSession((Object)missingDeployment));
        ((CacheEntryMutator)Mockito.verify((Object)this.mutator, (VerificationMode)Mockito.never())).mutate();
    }

    @Test
    public void addSession() {
        String id = "id";
        String deployment = "deployment";
        Mockito.when((Object)this.map.put(deployment, id)).thenReturn(null);
        this.sessions.addSession((Object)deployment, (Object)id);
        ((CacheEntryMutator)Mockito.verify((Object)this.mutator)).mutate();
        Mockito.reset((Object[])new Object[]{this.map, this.mutator});
        Mockito.when((Object)this.map.put(deployment, id)).thenReturn((Object)id);
        this.sessions.addSession((Object)deployment, (Object)id);
        ((CacheEntryMutator)Mockito.verify((Object)this.mutator, (VerificationMode)Mockito.never())).mutate();
    }

    @Test
    public void removeSession() {
        String deployment = "deployment";
        Mockito.when((Object)this.map.remove(deployment)).thenReturn((Object)"id");
        this.sessions.removeSession((Object)deployment);
        ((CacheEntryMutator)Mockito.verify((Object)this.mutator)).mutate();
        Mockito.reset((Object[])new Object[]{this.map, this.mutator});
        Mockito.when((Object)this.map.remove(deployment)).thenReturn(null);
        this.sessions.removeSession((Object)deployment);
        ((CacheEntryMutator)Mockito.verify((Object)this.mutator, (VerificationMode)Mockito.never())).mutate();
    }
}

