/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionManagerConfiguration;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.session.cache.SessionManagerFactoryProvider;
import org.wildfly.clustering.session.cache.SessionManagerParameters;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.common.function.Functions;

public abstract class SessionManagerITCase<P extends SessionManagerParameters> {
    private static final String DEPLOYMENT_CONTEXT = "deployment";
    private static final Supplier<AtomicReference<String>> SESSION_CONTEXT_FACTORY = AtomicReference::new;
    private final ExceptionBiFunction<P, String, SessionManagerFactoryProvider<String>, Exception> factory;

    protected SessionManagerITCase(ExceptionBiFunction<P, String, SessionManagerFactoryProvider<String>, Exception> factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void basic(P parameters) throws Exception {
        LinkedBlockingQueue<ImmutableSession> expiredSessions = new LinkedBlockingQueue<ImmutableSession>();
        TestSessionManagerConfiguration<String> managerConfig1 = new TestSessionManagerConfiguration<String>(expiredSessions, DEPLOYMENT_CONTEXT);
        TestSessionManagerConfiguration<String> managerConfig2 = new TestSessionManagerConfiguration<String>(expiredSessions, DEPLOYMENT_CONTEXT);
        try (SessionManagerFactoryProvider provider1 = (SessionManagerFactoryProvider)this.factory.apply(parameters, (Object)"member1");
             SessionManagerFactory factory1 = provider1.createSessionManagerFactory(SESSION_CONTEXT_FACTORY);){
            SessionManager manager1 = factory1.createSessionManager(managerConfig1);
            manager1.start();
            try (SessionManagerFactoryProvider provider2 = (SessionManagerFactoryProvider)this.factory.apply(parameters, (Object)"member2");
                 SessionManagerFactory factory2 = provider2.createSessionManagerFactory(SESSION_CONTEXT_FACTORY);){
                SessionManager manager2 = factory2.createSessionManager(managerConfig2);
                manager2.start();
                try {
                    String sessionId = (String)manager1.getIdentifierFactory().get();
                    this.verifyNoSession((SessionManager<AtomicReference<String>>)manager1, sessionId);
                    this.verifyNoSession((SessionManager<AtomicReference<String>>)manager2, sessionId);
                    UUID foo = UUID.randomUUID();
                    UUID bar = UUID.randomUUID();
                    this.createSession((SessionManager<AtomicReference<String>>)manager1, sessionId, Map.of("foo", foo, "bar", bar));
                    this.verifySession((SessionManager<AtomicReference<String>>)manager1, sessionId, Map.of("foo", foo, "bar", bar));
                    this.verifySession((SessionManager<AtomicReference<String>>)manager2, sessionId, Map.of("foo", foo, "bar", bar));
                    this.updateSession((SessionManager<AtomicReference<String>>)manager1, sessionId, Map.of("foo", new AbstractMap.SimpleEntry<UUID, Object>(foo, null), "bar", Map.entry(bar, 0)));
                    for (int i = 1; i <= 20; i += 2) {
                        this.updateSession((SessionManager<AtomicReference<String>>)manager1, sessionId, Map.of("bar", Map.entry(i - 1, i)));
                        this.updateSession((SessionManager<AtomicReference<String>>)manager2, sessionId, Map.of("bar", Map.entry(i, i + 1)));
                    }
                    this.invalidateSession((SessionManager<AtomicReference<String>>)manager1, sessionId);
                    this.verifyNoSession((SessionManager<AtomicReference<String>>)manager1, sessionId);
                    this.verifyNoSession((SessionManager<AtomicReference<String>>)manager2, sessionId);
                    Assertions.assertTrue((boolean)expiredSessions.isEmpty());
                }
                finally {
                    manager2.stop();
                }
            }
            finally {
                manager1.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void concurrent(P parameters) throws Exception {
        int threads = 10;
        int requests = 10;
        LinkedBlockingQueue<ImmutableSession> expiredSessions = new LinkedBlockingQueue<ImmutableSession>();
        TestSessionManagerConfiguration<String> managerConfig1 = new TestSessionManagerConfiguration<String>(expiredSessions, DEPLOYMENT_CONTEXT);
        TestSessionManagerConfiguration<String> managerConfig2 = new TestSessionManagerConfiguration<String>(expiredSessions, DEPLOYMENT_CONTEXT);
        try (SessionManagerFactoryProvider provider1 = (SessionManagerFactoryProvider)this.factory.apply(parameters, (Object)"member1");
             SessionManagerFactory factory1 = provider1.createSessionManagerFactory(SESSION_CONTEXT_FACTORY);){
            SessionManager manager1 = factory1.createSessionManager(managerConfig1);
            manager1.start();
            try (SessionManagerFactoryProvider provider2 = (SessionManagerFactoryProvider)this.factory.apply(parameters, (Object)"member2");
                 SessionManagerFactory factory2 = provider2.createSessionManagerFactory(SESSION_CONTEXT_FACTORY);){
                SessionManager manager2 = factory2.createSessionManager(managerConfig2);
                manager2.start();
                try {
                    String sessionId = (String)manager1.getIdentifierFactory().get();
                    AtomicInteger value = new AtomicInteger();
                    this.createSession((SessionManager<AtomicReference<String>>)manager1, sessionId, Map.of("value", value));
                    CompletionStage<Object> future = CompletableFuture.completedFuture(null);
                    for (int i = 0; i < threads; ++i) {
                        future = future.thenAcceptBoth(CompletableFuture.runAsync(() -> {
                            for (int j = 0; j < requests; ++j) {
                                this.requestSession((SessionManager<AtomicReference<String>>)manager1, sessionId, session -> {
                                    AtomicInteger v = (AtomicInteger)session.getAttributes().get("value");
                                    Assertions.assertNotNull((Object)v);
                                    v.incrementAndGet();
                                });
                            }
                        }), Functions.discardingBiConsumer());
                    }
                    future.join();
                    AtomicInteger expected = new AtomicInteger(threads * requests);
                    this.requestSession((SessionManager<AtomicReference<String>>)manager2, sessionId, session -> this.verifySessionAttribute((ImmutableSession)session, "value", expected, (value1, value2) -> value1.get() == value2.get()));
                    this.invalidateSession((SessionManager<AtomicReference<String>>)manager2, sessionId);
                }
                finally {
                    manager2.stop();
                }
            }
            finally {
                manager1.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expiration(P parameters) throws Exception {
        Duration expirationDuration = Duration.ofSeconds(120L);
        LinkedBlockingQueue<ImmutableSession> expiredSessions = new LinkedBlockingQueue<ImmutableSession>();
        TestSessionManagerConfiguration<String> managerConfig1 = new TestSessionManagerConfiguration<String>(expiredSessions, DEPLOYMENT_CONTEXT);
        TestSessionManagerConfiguration<String> managerConfig2 = new TestSessionManagerConfiguration<String>(expiredSessions, DEPLOYMENT_CONTEXT);
        try (SessionManagerFactoryProvider provider1 = (SessionManagerFactoryProvider)this.factory.apply(parameters, (Object)"member1");
             SessionManagerFactory factory1 = provider1.createSessionManagerFactory(SESSION_CONTEXT_FACTORY);){
            SessionManager manager1 = factory1.createSessionManager(managerConfig1);
            manager1.start();
            try (SessionManagerFactoryProvider provider2 = (SessionManagerFactoryProvider)this.factory.apply(parameters, (Object)"member2");
                 SessionManagerFactory factory2 = provider2.createSessionManagerFactory(SESSION_CONTEXT_FACTORY);){
                SessionManager manager2 = factory2.createSessionManager(managerConfig2);
                manager2.start();
                try {
                    String sessionId = (String)manager1.getIdentifierFactory().get();
                    UUID foo = UUID.randomUUID();
                    UUID bar = UUID.randomUUID();
                    this.createSession((SessionManager<AtomicReference<String>>)manager1, sessionId, Map.of("foo", foo, "bar", bar));
                    this.requestSession((SessionManager<AtomicReference<String>>)manager1, sessionId, session -> session.getMetaData().setTimeout(Duration.ofSeconds(2L)));
                    TimeUnit.SECONDS.sleep(1L);
                    this.verifySession((SessionManager<AtomicReference<String>>)manager2, sessionId, Map.of("foo", foo, "bar", bar));
                    TimeUnit.SECONDS.sleep(1L);
                    this.verifySession((SessionManager<AtomicReference<String>>)manager2, sessionId, Map.of("foo", foo, "bar", bar));
                    TimeUnit.SECONDS.sleep(1L);
                    this.verifySession((SessionManager<AtomicReference<String>>)manager2, sessionId, Map.of("foo", foo, "bar", bar));
                    try {
                        Instant start = Instant.now();
                        ImmutableSession expiredSession = (ImmutableSession)expiredSessions.poll(expirationDuration.getSeconds(), TimeUnit.SECONDS);
                        Assertions.assertNotNull((Object)expiredSession, () -> String.format("No expiration event received within %s seconds", expirationDuration.getSeconds()));
                        System.out.println(String.format("Received expiration event for %s after %s", expiredSession.getId(), Duration.between(start, Instant.now())));
                        Assertions.assertEquals((Object)sessionId, (Object)expiredSession.getId());
                        Assertions.assertFalse((boolean)expiredSession.isValid());
                        Assertions.assertFalse((boolean)expiredSession.getMetaData().isNew());
                        Assertions.assertTrue((boolean)expiredSession.getMetaData().isExpired());
                        Assertions.assertFalse((boolean)expiredSession.getMetaData().isImmortal());
                        this.verifySessionAttributes(expiredSession, Map.of("foo", foo, "bar", bar));
                        Assertions.assertEquals((int)0, (int)expiredSessions.size(), (String)((Object)expiredSessions).toString());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    this.verifyNoSession((SessionManager<AtomicReference<String>>)manager1, sessionId);
                    this.verifyNoSession((SessionManager<AtomicReference<String>>)manager2, sessionId);
                }
                finally {
                    manager2.stop();
                }
            }
            finally {
                manager1.stop();
            }
        }
    }

    private void createSession(SessionManager<AtomicReference<String>> manager, String sessionId, Map<String, Object> attributes) {
        this.requestSession(manager, arg_0 -> manager.createSession(arg_0), sessionId, session -> {
            Assertions.assertTrue((boolean)session.getMetaData().isNew());
            this.verifySessionMetaData((Session<AtomicReference<String>>)session);
            this.verifySessionAttributes((ImmutableSession)session, Map.of());
            this.updateSessionAttributes((Session<AtomicReference<String>>)session, attributes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new AbstractMap.SimpleEntry(null, entry.getValue()))));
            this.verifySessionAttributes((ImmutableSession)session, attributes);
        });
    }

    private void verifySession(SessionManager<AtomicReference<String>> manager, String sessionId, Map<String, Object> attributes) {
        this.requestSession(manager, sessionId, session -> {
            Assertions.assertFalse((boolean)session.getMetaData().isNew());
            this.verifySessionMetaData((Session<AtomicReference<String>>)session);
            this.verifySessionAttributes((ImmutableSession)session, attributes);
        });
    }

    private void updateSession(SessionManager<AtomicReference<String>> manager, String sessionId, Map<String, Map.Entry<Object, Object>> attributes) {
        this.requestSession(manager, sessionId, session -> {
            Assertions.assertNotNull((Object)session);
            Assertions.assertEquals((Object)sessionId, (Object)session.getId());
            Assertions.assertFalse((boolean)session.getMetaData().isNew());
            this.verifySessionMetaData((Session<AtomicReference<String>>)session);
            this.updateSessionAttributes((Session<AtomicReference<String>>)session, attributes);
        });
    }

    private void invalidateSession(SessionManager<AtomicReference<String>> manager, String sessionId) {
        this.requestSession(manager, sessionId, session -> {
            session.invalidate();
            Assertions.assertFalse((boolean)session.isValid());
            Assertions.assertThrows(IllegalStateException.class, () -> session.getAttributes(), (String)session.getClass().getName());
            Assertions.assertThrows(IllegalStateException.class, () -> session.getMetaData(), (String)session.getClass().getName());
        });
    }

    private void requestSession(SessionManager<AtomicReference<String>> manager, String sessionId, Consumer<Session<AtomicReference<String>>> action) {
        this.requestSession(manager, arg_0 -> manager.findSession(arg_0), sessionId, action);
    }

    private void requestSession(SessionManager<AtomicReference<String>> manager, Function<String, Session<AtomicReference<String>>> sessionFactory, String sessionId, Consumer<Session<AtomicReference<String>>> action) {
        Instant start = Instant.now();
        try (Batch batch = (Batch)manager.getBatchFactory().get();
             Session<AtomicReference<String>> session = sessionFactory.apply(sessionId);){
            Assertions.assertNotNull(session);
            Assertions.assertEquals((Object)sessionId, (Object)session.getId());
            action.accept(session);
            if (session.isValid()) {
                SessionMetaData metaData = session.getMetaData();
                Instant end = Instant.now();
                metaData.setLastAccess(start, end);
                Assertions.assertFalse((boolean)metaData.isNew());
                if (!(Thread.currentThread() instanceof ForkJoinWorkerThread)) {
                    Assertions.assertEquals((long)0L, (long)Duration.between(metaData.getLastAccessStartTime(), start).getSeconds(), (String)Duration.between(metaData.getLastAccessStartTime(), start).toString());
                    Assertions.assertEquals((long)0L, (long)Duration.between(metaData.getLastAccessStartTime(), start).truncatedTo(ChronoUnit.MILLIS).getNano(), (String)Duration.between(metaData.getLastAccessStartTime(), start).toString());
                    Assertions.assertEquals((long)0L, (long)Duration.between(end, metaData.getLastAccessEndTime()).getSeconds(), (String)Duration.between(end, metaData.getLastAccessEndTime()).toString());
                }
            }
        }
    }

    private void verifySessionMetaData(Session<AtomicReference<String>> session) {
        Assertions.assertTrue((boolean)session.isValid());
        SessionMetaData metaData = session.getMetaData();
        Assertions.assertFalse((boolean)metaData.isImmortal(), (String)metaData.toString());
        Assertions.assertFalse((boolean)metaData.isExpired(), (String)metaData.toString());
        if (metaData.isNew()) {
            Assertions.assertNull((Object)metaData.getLastAccessStartTime());
            Assertions.assertNull((Object)metaData.getLastAccessEndTime());
        } else {
            Assertions.assertNotNull((Object)metaData.getLastAccessStartTime());
            Assertions.assertNotNull((Object)metaData.getLastAccessEndTime());
            if (metaData.getLastAccessStartTime().isBefore(metaData.getCreationTime())) {
                Assertions.assertEquals((long)0L, (long)Duration.between(metaData.getLastAccessStartTime(), metaData.getCreationTime()).getSeconds(), (String)metaData.toString());
            }
            Assertions.assertTrue((boolean)metaData.getLastAccessStartTime().isBefore(metaData.getLastAccessEndTime()), (String)metaData.toString());
        }
    }

    private void verifySessionAttributes(ImmutableSession session, Map<String, Object> attributes) {
        Assertions.assertTrue((boolean)session.getAttributes().keySet().containsAll(attributes.keySet()));
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            this.verifySessionAttribute(session, entry.getKey(), entry.getValue(), Objects::equals);
        }
    }

    private <T> void verifySessionAttribute(ImmutableSession session, String name, T expected, BiPredicate<T, T> equals) {
        Object value = session.getAttributes().get(name);
        Assertions.assertTrue((boolean)equals.test(expected, value), () -> String.format("Expected %s, Actual %s", expected, value));
    }

    private void updateSessionAttributes(Session<AtomicReference<String>> session, Map<String, Map.Entry<Object, Object>> attributes) {
        for (Map.Entry<String, Map.Entry<Object, Object>> entry : attributes.entrySet()) {
            String name = entry.getKey();
            Object expected = entry.getValue().getKey();
            Object value = entry.getValue().getValue();
            if (value != null) {
                Assertions.assertEquals((Object)expected, (Object)session.getAttributes().put(name, value));
                continue;
            }
            Assertions.assertEquals((Object)expected, session.getAttributes().remove(name));
        }
    }

    private void verifyNoSession(SessionManager<AtomicReference<String>> manager, String sessionId) {
        try (Batch batch = (Batch)manager.getBatchFactory().get();
             Session session = manager.findSession(sessionId);){
            Assertions.assertNull((Object)session);
        }
    }

    private static class TestSessionManagerConfiguration<C>
    implements SessionManagerConfiguration<C> {
        private final BlockingQueue<ImmutableSession> expired;
        private final C context;

        TestSessionManagerConfiguration(BlockingQueue<ImmutableSession> expired, C context) {
            this.expired = expired;
            this.context = context;
        }

        public Supplier<String> getIdentifierFactory() {
            return () -> UUID.randomUUID().toString();
        }

        public Consumer<ImmutableSession> getExpirationListener() {
            return this.expired::add;
        }

        public Duration getTimeout() {
            return Duration.ofMinutes(1L);
        }

        public C getContext() {
            return this.context;
        }
    }
}

