/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.time.Duration;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.server.offset.Offset;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionAccessMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaDataEntryOffsets;

public abstract class AbstractSessionAccessMetaDataEntryTestCase
implements Consumer<SessionAccessMetaDataEntry> {
    private final Duration originalSinceCreation = Duration.ofMinutes(1L);
    private final Duration originalLastAccess = Duration.ofSeconds(1L);
    private final Duration sinceCreationDelta = Duration.ofMinutes(1L);
    private final Duration lastAccessDelta = Duration.ofSeconds(1L);
    private final Duration updatedSinceCreation = this.originalSinceCreation.plus(this.sinceCreationDelta);
    private final Duration updatedLastAccess = this.originalLastAccess.plus(this.lastAccessDelta);

    @Test
    public void test() {
        DefaultSessionAccessMetaDataEntry entry = new DefaultSessionAccessMetaDataEntry();
        Assertions.assertTrue((boolean)entry.getSinceCreationDuration().isZero());
        Assertions.assertTrue((boolean)entry.getLastAccessDuration().isZero());
        entry.setLastAccessDuration(this.originalSinceCreation, this.originalLastAccess);
        this.verifyOriginalState((SessionAccessMetaData)entry);
        SessionAccessMetaDataEntryOffsets offsets = (SessionAccessMetaDataEntryOffsets)Mockito.mock(SessionAccessMetaDataEntryOffsets.class);
        ((SessionAccessMetaDataEntryOffsets)Mockito.doReturn((Object)Offset.forDuration((Duration)this.sinceCreationDelta)).when((Object)offsets)).getSinceCreationOffset();
        ((SessionAccessMetaDataEntryOffsets)Mockito.doReturn((Object)Offset.forDuration((Duration)this.lastAccessDelta)).when((Object)offsets)).getLastAccessOffset();
        SessionAccessMetaDataEntry remapped = entry.remap(offsets);
        this.verifyUpdatedState((SessionAccessMetaData)remapped);
        this.verifyOriginalState((SessionAccessMetaData)entry);
        this.accept(entry);
    }

    void updateState(SessionAccessMetaData entry) {
        entry.setLastAccessDuration(this.updatedSinceCreation, this.updatedLastAccess);
    }

    void verifyOriginalState(SessionAccessMetaData metaData) {
        Assertions.assertEquals((Object)this.originalSinceCreation, (Object)metaData.getSinceCreationDuration());
        Assertions.assertEquals((Object)this.originalLastAccess, (Object)metaData.getLastAccessDuration());
    }

    void verifyUpdatedState(SessionAccessMetaData metaData) {
        Assertions.assertEquals((Object)this.updatedSinceCreation, (Object)metaData.getSinceCreationDuration());
        Assertions.assertEquals((Object)this.updatedLastAccess, (Object)metaData.getLastAccessDuration());
    }
}

